/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.asserts;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.util.asserts.Require;
import org.apache.commons.lang3.StringUtils;

public class JudgeUtil {
    public static boolean match(Object object, Require require, Object ... params) {
        switch (require) {
            case isTrue: {
                return (Boolean)object;
            }
            case arrLength: {
                return params != null && (Integer)object == params.length;
            }
            case equals: {
                return JudgeUtil.match(object, Require.notNull, new Object[0]) && JudgeUtil.match(1, Require.arrLength, params) && object.equals(params[0]);
            }
            case notNull: {
                return object != null;
            }
            case notEmpty: {
                return JudgeUtil.match(object, Require.notNull, new Object[0]) && object.toString().length() > 0;
            }
            case mobileFormat: {
                return object != null && StringUtils.isNumeric((CharSequence)object.toString()) && StringUtils.length((CharSequence)object.toString()) == 11;
            }
            case openIdFormat: {
                return JudgeUtil.match(object, Require.notEmpty, new Object[0]) && ((String)object).length() >= 28 && ((String)object).length() <= 32;
            }
            case isNumber: {
                return JudgeUtil.match(object, Require.notNull, new Object[0]) && StringUtils.isNumeric((CharSequence)((String)object));
            }
            case between: {
                return JudgeUtil.match(2, Require.arrLength, params) && object instanceof Comparable && JudgeUtil.match(object.getClass().getTypeName(), Require.equals, params[0].getClass().getTypeName()) && JudgeUtil.match(object.getClass().getTypeName(), Require.equals, params[1].getClass().getTypeName()) && ((Comparable)object).compareTo(params[0]) >= 0 && ((Comparable)object).compareTo(params[1]) < 0;
            }
            case trimNotEmpty: {
                return JudgeUtil.match(object, Require.notEmpty, new Object[0]) && JudgeUtil.match(((String)object).trim(), Require.notEmpty, new Object[0]);
            }
            case phone: {
                return JudgeUtil.match(object, Require.isNumber, params) && object.toString().length() == 11 && object.toString().substring(0, 1).equals("1");
            }
        }
        throw new UnsupportedException("\u4e0d\u652f\u6301\u7684\u7c7b\u578bobject:%s,Require:%s", new Object[]{object, require});
    }
}

