/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.cache.prepare.merge;

import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.util.cache.prepare.merge.data.PersistenceIncrementExecutor;
import com.mini.framework.util.cache.prepare.merge.data.PrepareAtomCacheExecutor;
import com.mini.framework.util.cache.prepare.merge.data.WorkDelayLock;
import com.mini.framework.util.function.LazyAssignBean;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.thread.AbstractAsyncThreadExecutor;
import com.mini.framework.util.thread.RunnableThrowableHandler;
import com.mini.framework.util.thread.ThreadQuietSleep;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IncrementPrepareCacheAsyncMergeFlow {
    private static Logger logger = LogManager.getLogger(IncrementPrepareCacheAsyncMergeFlow.class);
    private String flowName;
    private AbstractAsyncThreadExecutor asyncExecutor;
    private PrepareAtomCacheExecutor prepareAtomExecutor;
    private WorkDelayLock lock;

    public IncrementPrepareCacheAsyncMergeFlow(String flowName, AbstractAsyncThreadExecutor asyncExecutor, PrepareAtomCacheExecutor prepareCacheExecute, WorkDelayLock lock) {
        this.flowName = flowName;
        this.asyncExecutor = asyncExecutor;
        this.prepareAtomExecutor = prepareCacheExecute;
        this.lock = lock;
    }

    public <E extends CustomException> void executeFlow(String key, int increment, PersistenceIncrementExecutor persistenceIncrement, Function<String, E> exceptionSupplier) throws E {
        this.prepareSurplusCheck(key, increment, persistenceIncrement, exceptionSupplier);
        this.executeWriteIncrement(key, increment, persistenceIncrement);
    }

    public <E extends CustomException> void prepareSurplusCheck(String key, int increment, PersistenceIncrementExecutor persistenceIncrement, Function<String, E> exceptionSupplier) throws E {
        if (increment < 0) {
            long currentCachedSurplus = this.prepareAtomExecutor.querySurplus(key);
            long currentSwapStoreCachedSurplus = this.prepareAtomExecutor.querySwapStoreSurplus(key);
            long currentPersistenceSurplus = persistenceIncrement.querySurplus(key);
            long surplusIfExecute = currentCachedSurplus + currentSwapStoreCachedSurplus + currentPersistenceSurplus + (long)increment;
            logger.debug(String.format("flow:" + this.flowName + " \u901a\u8fc7prepareCheck\u65b9\u6cd5 \u5f97\u5230 surplusIfExecute = currentCachedSurplus(%s) + currentSwapStoreCachedSurplus(%s) + currentPersistenceSurplus(%s) + increment(%s) = %s", currentCachedSurplus, currentSwapStoreCachedSurplus, currentPersistenceSurplus, increment, surplusIfExecute));
            if (surplusIfExecute < 0L) {
                throw (CustomException)exceptionSupplier.apply(String.format("flow:%s \u5f53\u524dkey:[%s],\u7684\u73b0\u6709\u91cf\u4e3a:[%s]\u4e0d\u53ef\u4ee5\u5e94\u7528\u589e\u91cf:[%s]", this.flowName, key, currentCachedSurplus + currentSwapStoreCachedSurplus + currentPersistenceSurplus, increment));
            }
        } else {
            logger.debug(String.format("flow:%s \u9884\u5148\u5269\u4f59\u91cf\u68c0\u67e5,key:[%s],increment:[%s],increment>=0 \u4e0d\u505a\u5269\u4f59\u91cf\u68c0\u67e5\u4e86", this.flowName, key, increment));
        }
    }

    public void executeWriteIncrement(String key, int increment, PersistenceIncrementExecutor persistenceIncrement) {
        LazyAssignBean runnableBean = LazyAssignBean.create();
        long mainAfterIncrement = this.prepareAtomExecutor.writeIncrement(key, increment);
        Runnable runnable = () -> {
            String workName = Thread.currentThread().getName();
            Event5WBuilder event = Event5WBuilder.event(2, "executeWriteIncrement").who("flow:%s \u7ebf\u7a0b:[%s]", this.flowName, workName).what("\u4ece\u9884\u7f13\u5b58\u4e2d\u540c\u6b65key:[%s]\u7684\u589e\u91cf:[%s]\u5230\u6570\u636e\u5e93,mainAfterSurplus:[%s]", key, increment, mainAfterIncrement);
            Optional<String> lockedOptional = this.lock.triesLock(key, workName);
            if (lockedOptional.isPresent()) {
                logger.debug((Object)event.why("\u5f53\u524d\u5df2\u6709\u522b\u7ebf\u7a0b:[%s]\u6807\u8bb0\u540c\u6b65\u5de5\u4f5c", lockedOptional.get()).result("\u4ec0\u4e48\u90fd\u4e0d\u7528\u505a\u76f4\u63a5\u7ed3\u675f", new Object[0]));
            } else {
                logger.info((Object)event.why("\u5f53\u524d\u6ca1\u6709\u522b\u7684\u7ebf\u7a0b\u6807\u8bb0\u540c\u6b65\u5de5\u4f5c\uff0c\u53ef\u4ee5\u5de5\u4f5c", new Object[0]).how("\u5c1d\u8bd5\u4ece\u9884\u7f13\u5b58\u4e2d\u540c\u6b65", new Object[0]));
                ThreadQuietSleep.sleepMillisOrRun(1000L, event.result("\u7ebf\u7a0b\u5ef6\u8fdf1000\u6beb\u79d2\u88ab\u5524\u9192,\u7ee7\u7eed\u5de5\u4f5c", new Object[0]).create(), new Object[0]);
                int historySwapStoreSurplus = this.prepareAtomExecutor.cutSwapStoreSurplus(key);
                logger.debug((Object)event.result("\u539f\u6765\u7684\u4ea4\u6362\u533a\u6570\u91cf\u4e3a:[%s],\u73b0\u5df2\u6e05\u96f6", historySwapStoreSurplus));
                int currentCachedSurplus = this.prepareAtomExecutor.cutSurplus(key);
                int requireCorrectIncrement = -currentCachedSurplus;
                this.prepareAtomExecutor.writeSwapStoreIncrement(key, currentCachedSurplus);
                if (requireCorrectIncrement == 0) {
                    logger.debug((Object)event.why("\u4eceredis\u4e2d\u622a\u53d6\u51fa\u9700\u8981\u4fee\u6b63\u7684\u6570\u5b57\u4e3a0", new Object[0]).result("\u4ec0\u4e48\u90fd\u4e0d\u7528\u505a", new Object[0]));
                } else {
                    logger.info((Object)event.why("\u4eceredis\u4e2d\u622a\u53d6\u51fa\u5269\u4f59\u91cf:[%s],\u8ba1\u7b97\u51fa\u9700\u8981\u4fee\u6b63\u7684\u6570\u5b57\u4e3a:[%s]", currentCachedSurplus, requireCorrectIncrement).result("\u7ee7\u7eed\u5c1d\u8bd5\u64cd\u4f5c\u9884\u7f13\u5b58\u548c\u6301\u4e45\u5c42", new Object[0]));
                    persistenceIncrement.writeIncrement(key, currentCachedSurplus, error -> {
                        logger.debug((Object)event.why("\u5c1d\u8bd5\u64cd\u4f5c\u9884\u7f13\u5b58\u548c\u6301\u4e45\u5c42\u5931\u8d25\u4e86", new Object[0]).result("\u73b0\u5728\u53bb\u5c1d\u8bd5\u53cd\u5411\u5199\u5165\u9884\u7f13\u5b58\u4e2d", new Object[0]), error);
                        logger.info((Object)event.why("\u5c1d\u8bd5\u64cd\u4f5c\u9884\u7f13\u5b58\u548c\u6301\u4e45\u5c42\u5931\u8d25\u4e86,error:[%s]", error.getMessage()).result("\u73b0\u5728\u53bb\u5c1d\u8bd5\u53cd\u5411\u5199\u5165\u9884\u7f13\u5b58\u4e2d", new Object[0]));
                        this.prepareAtomExecutor.writeIncrement(key, currentCachedSurplus);
                    });
                    this.prepareAtomExecutor.cutSwapStoreSurplus(key);
                    this.lock.releaseLock(key);
                    this.asyncExecutor.execute((Runnable)runnableBean.showBean());
                }
                this.prepareAtomExecutor.cutSwapStoreSurplus(key);
                this.lock.releaseLock(key);
            }
        };
        runnable = RunnableThrowableHandler.assignLogError(runnable, "flow:%s executeWriteIncrement\u9519\u8bef,key:[%s],increment:[%s]", this.flowName, key, increment);
        runnableBean.initBean(runnable);
        this.asyncExecutor.execute(runnable);
    }
}

