/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.generic.define;

import com.mini.framework.util.generic.define.OptionalSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OptionalSetString
extends OptionalSet<String> {
    private static OptionalSetString createEmpty() {
        return new OptionalSetString();
    }

    public static OptionalSetString ofNullable(Collection<String> collString) {
        return collString == null ? OptionalSetString.createEmpty() : OptionalSetString.of(collString);
    }

    public static OptionalSetString of(Collection<String> collString) {
        OptionalSetString set = new OptionalSetString();
        Objects.requireNonNull(collString, "collString\u4e0d\u80fd\u4e3a\u7a7a");
        set.value = new LinkedHashSet<String>(collString);
        return set;
    }

    public static OptionalSetString ofNullable(String ... ts) {
        return ts == null ? OptionalSetString.createEmpty() : OptionalSetString.of(ts);
    }

    public static OptionalSetString of(String ... ts) {
        return OptionalSetString.of(Stream.of(ts).collect(Collectors.toSet()));
    }

    public static OptionalSetString ofNullable(String arr) {
        return arr == null ? OptionalSetString.createEmpty() : OptionalSetString.of(arr);
    }

    public Optional<Set<String>> out() {
        return this.out(false);
    }

    public Optional<Set<String>> outNotZero() {
        return this.out(true);
    }

    public Optional<Set<String>> out(boolean zeroAsNull) {
        if (zeroAsNull && this.value != null && this.value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.value);
    }

    public String toString() {
        return this.out().toString();
    }
}

