/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.oss.bean.offset;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.oss.bean.offset.GridOffsetWaterMarkNumber;
import com.mini.framework.util.oss.bean.offset.SimpleGridOffsetWaterMarkNumber;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum GridOffsetWaterMarkType implements GridOffsetWaterMarkNumber
{
    postOffset1("\u6d77\u62a5\u9884\u8bbe\u4f4d\u7f6e1,\u653e\u5728\u5de6\u4e0b\u65b9\u7684\u5c0f\u7a0b\u5e8f\u7801", 100, 85, 95, 100, 85, 95),
    postOffset2("\u6d77\u62a5\u9884\u8bbe\u4f4d\u7f6e2,\u653e\u5728\u5de6\u4e0b\u65b9\u7684\u5c0f\u7a0b\u5e8f\u7801", 8, 7, 8, 5, 4, 5);

    private String desc;
    private int ws;
    private int wf;
    private int wt;
    private int hs;
    private int hf;
    private int ht;

    private GridOffsetWaterMarkType(String desc, int ws, int wf, int wt, int hs, int hf, int ht) {
        this.desc = desc;
        this.ws = ws;
        this.wf = wf;
        this.wt = wt;
        this.hs = hs;
        this.hf = hf;
        this.ht = ht;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public int getWs() {
        return this.ws;
    }

    @Override
    public int getWf() {
        return this.wf;
    }

    @Override
    public int getWt() {
        return this.wt;
    }

    @Override
    public int getHs() {
        return this.hs;
    }

    @Override
    public int getHf() {
        return this.hf;
    }

    @Override
    public int getHt() {
        return this.ht;
    }

    public static Optional<GridOffsetWaterMarkNumber> parseOffset(String numberOffset) {
        String[] numStrs;
        AssertUtil.assertMethodRequire(numberOffset, "numberOffset");
        for (String num : numStrs = numberOffset.split(",")) {
            if (StringUtils.isNumeric((CharSequence)num)) continue;
            return Optional.empty();
        }
        Integer[] nums = Stream.of(numStrs).map(Integer::parseInt).collect(Collectors.toList()).toArray(new Integer[0]);
        if (numStrs.length == 4) {
            String desc = "\u901a\u8fc74\u4e2a\u6570\u5b57\u5b9a\u4f4d:" + numberOffset;
            SimpleGridOffsetWaterMarkNumber offset = new SimpleGridOffsetWaterMarkNumber(desc, 100, nums[0], nums[1], 100, nums[2], nums[3]);
            return Optional.of(offset);
        }
        if (numStrs.length == 6) {
            String desc = "\u901a\u8fc76\u4e2a\u6570\u5b57\u5b9a\u4f4d:" + numberOffset;
            SimpleGridOffsetWaterMarkNumber offset = new SimpleGridOffsetWaterMarkNumber(desc, nums[0], nums[1], nums[2], nums[3], nums[4], nums[5]);
            return Optional.of(offset);
        }
        return Optional.empty();
    }

    @Override
    public String serialize() {
        return String.format("%s,%s,%s,%s,%s,%s", this.ws, this.wf, this.wt, this.hs, this.hf, this.ht);
    }
}

