/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.summation.bean;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.report.statistics.protocol.StatisticsSerializeParams;
import com.mini.framework.util.report.statistics.protocol.TimeRegionRange;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionTimeOutNames;
import com.mini.framework.util.report.statistics.summation.bean.SummationElementAmount;
import java.util.Date;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class NativeRegionSummationElementAmount
extends SummationElementAmount {
    private String paramsSerialize;
    private String paramsSerializeMd5;
    private Date regionOffset;
    private TimeRegionUnit regionUnit;
    private String regionUnionKey;
    private NativeRegionTimeOutNames timeOutNames;

    public NativeRegionSummationElementAmount copy() {
        NativeRegionSummationElementAmount copy = new NativeRegionSummationElementAmount();
        this.copyToOther(copy);
        copy.paramsSerializeMd5 = this.paramsSerializeMd5;
        copy.paramsSerialize = this.paramsSerialize;
        copy.regionUnionKey = this.regionUnionKey;
        copy.regionUnit = this.regionUnit;
        copy.regionOffset = this.regionOffset;
        copy.timeOutNames = this.timeOutNames;
        return copy;
    }

    @Override
    public void clearRedundancyFields() {
        super.clearRedundancyFields();
        this.paramsSerialize = null;
        this.paramsSerializeMd5 = null;
        this.regionOffset = null;
        this.regionUnit = null;
        this.regionUnionKey = null;
    }

    public NativeRegionSummationElementAmount fillOutNames(Function<Date, NativeRegionTimeOutNames> namesMapper) {
        this.timeOutNames = namesMapper.apply(this.regionOffset);
        return this;
    }

    public static String showRegionAndParamsMd5UnionKey(String regionUnionKey, String paramsSerializeMd5) {
        return String.format("%s--%s", regionUnionKey, paramsSerializeMd5);
    }

    public static String showRegionAndParamsMd5UnionKey(TimeRegionRange region, StatisticsSerializeParams params) {
        return NativeRegionSummationElementAmount.showRegionAndParamsMd5UnionKey(region.unitOffsetUnionString(), params.uniqueSerializeMd5());
    }

    public String showRegionAndParamsMd5UnionKey() {
        return NativeRegionSummationElementAmount.showRegionAndParamsMd5UnionKey(this.regionUnionKey, this.paramsSerializeMd5);
    }

    public static NativeRegionSummationElementAmount create(StatisticsSerializeParams params, TimeRegionRange requireRange, SummationElementAmount summationAmount) {
        return NativeRegionSummationElementAmount.create(params.uniqueSerialize(), params.uniqueSerializeMd5(), requireRange, summationAmount);
    }

    public static NativeRegionSummationElementAmount create(String paramsSerialize, String paramsSerializeMd5, TimeRegionRange requireRange, SummationElementAmount summationAmount) {
        NativeRegionSummationElementAmount instance = new NativeRegionSummationElementAmount();
        instance.paramsSerialize = paramsSerialize;
        instance.paramsSerializeMd5 = paramsSerializeMd5;
        instance.regionOffset = requireRange.getOffset();
        instance.regionUnit = requireRange.getUnit();
        instance.regionUnionKey = requireRange.unitOffsetUnionString();
        instance.setResultMeta(summationAmount.getResultMeta());
        instance.setCount(summationAmount.count);
        instance.setSum(summationAmount.sum);
        instance.setMax(summationAmount.max);
        instance.setMin(summationAmount.min);
        return instance;
    }

    public boolean matchParamsMd5(StatisticsSerializeParams params) {
        return this.matchParamsMd5(params.uniqueSerializeMd5());
    }

    public boolean matchParamsMd5(String paramsSerializeMd5) {
        return this.paramsSerializeMd5.equals(paramsSerializeMd5);
    }

    public boolean matchRegionUnionKey(TimeRegionRange regionRange) {
        AssertUtil.assertMethodRequire(regionRange, "regionRange");
        return this.matchRegionUnionKey(regionRange.unitOffsetUnionString());
    }

    public boolean matchRegionUnionKey(String regionUnionKey) {
        AssertUtil.assertMethodRequire(regionUnionKey, "regionUnionKey");
        return regionUnionKey.equals(this.regionUnionKey);
    }

    public TimeRegionRange mapperRegionRange() {
        return TimeRegionRange.create(this.regionUnit, this.regionOffset);
    }

    public String getParamsSerialize() {
        return this.paramsSerialize;
    }

    public void setParamsSerialize(String paramsSerialize) {
        this.paramsSerialize = paramsSerialize;
    }

    public String getParamsSerializeMd5() {
        return this.paramsSerializeMd5;
    }

    public void setParamsSerializeMd5(String paramsSerializeMd5) {
        this.paramsSerializeMd5 = paramsSerializeMd5;
    }

    public Date getRegionOffset() {
        return this.regionOffset;
    }

    public void setRegionOffset(Date regionOffset) {
        this.regionOffset = regionOffset;
    }

    public TimeRegionUnit getRegionUnit() {
        return this.regionUnit;
    }

    public void setRegionUnit(TimeRegionUnit regionUnit) {
        this.regionUnit = regionUnit;
    }

    public String getRegionUnionKey() {
        return this.regionUnionKey;
    }

    public void setRegionUnionKey(String regionUnionKey) {
        this.regionUnionKey = regionUnionKey;
    }

    public NativeRegionTimeOutNames getTimeOutNames() {
        return this.timeOutNames;
    }

    public void setTimeOutNames(NativeRegionTimeOutNames timeOutNames) {
        this.timeOutNames = timeOutNames;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

