/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.summation.bean.compare;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.report.statistics.protocol.DivideDenominatorNumeratorSummation;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionSummationElementAmount;
import com.mini.framework.util.report.statistics.summation.bean.compare.BothSummationCompare;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class BothSameRoundSummationCompare
implements OneStatisticsResult,
DivideDenominatorNumeratorSummation<BothSameRoundSummationCompare> {
    private StatisticsResultMeta resultMeta;
    private ForkQueryProcess process;
    private NativeRegionSummationElementAmount main;
    private NativeRegionSummationElementAmount roundContrast;
    private NativeRegionSummationElementAmount sameContrast;
    private BothSummationCompare roundCompare;
    private BothSummationCompare sameCompare;

    public static BothSameRoundSummationCompare create(NativeRegionSummationElementAmount main, NativeRegionSummationElementAmount roundContrast, Optional<NativeRegionSummationElementAmount> sameContrastOptional) {
        BothSameRoundSummationCompare instance = new BothSameRoundSummationCompare();
        instance.main = main;
        instance.roundContrast = roundContrast;
        sameContrastOptional.ifPresent(instance::setSameContrast);
        instance.fillRoundSameCompareIfProvide();
        return instance;
    }

    @Override
    public void mapperAmountDivideByOther(long expand, boolean numeratorSum, boolean denominatorSum, BothSameRoundSummationCompare other) {
        this.mergeOtherResultMeta(other);
        this.main.mapperAmountDivideByOther(expand, numeratorSum, denominatorSum, other.main);
        this.roundCompare = null;
        this.sameCompare = null;
        if (this.roundContrast != null && other.roundContrast != null) {
            this.roundContrast.mapperAmountDivideByOther(expand, numeratorSum, denominatorSum, other.roundContrast);
        }
        if (this.sameContrast != null && other.sameContrast != null) {
            this.sameContrast.mapperAmountDivideByOther(expand, numeratorSum, denominatorSum, other.sameContrast);
        }
        if (this.main.haveAmount()) {
            this.fillRoundSameCompareIfProvide();
        }
    }

    public BothSameRoundSummationCompare fillRoundSameCompareIfProvide() {
        if (this.sameContrast != null && this.sameContrast.haveAmount()) {
            this.fillSameCompare();
        }
        if (this.roundContrast != null && this.roundContrast.haveAmount()) {
            this.fillRoundCompare();
        }
        return this;
    }

    public BothSameRoundSummationCompare fillSameCompare() {
        AssertUtil.assertNotFatal(this.sameContrast != null, "sameContrast\u4e3a\u7a7a\u65f6\u4e0d\u80fd\u4f7f\u7528fillSameCompare()", new Object[0]);
        this.sameCompare = BothSummationCompare.createSummationInstance(this.main, this.sameContrast);
        return this;
    }

    public BothSameRoundSummationCompare fillRoundCompare() {
        AssertUtil.assertNotFatal(this.roundContrast != null, "roundContrast\u4e3a\u7a7a\u65f6\u4e0d\u80fd\u4f7f\u7528fillRoundCompare()", new Object[0]);
        this.roundCompare = BothSummationCompare.createSummationInstance(this.main, this.roundContrast);
        return this;
    }

    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(this.resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    @Override
    public void clearRedundancyFields() {
        Stream.of(this.main, this.roundContrast, this.sameContrast, this.roundCompare, this.sameCompare).filter(Objects::nonNull).forEach(OneStatisticsResult::clearRedundancyFields);
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(this.process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public NativeRegionSummationElementAmount getMain() {
        return this.main;
    }

    public void setMain(NativeRegionSummationElementAmount main) {
        this.main = main;
    }

    public NativeRegionSummationElementAmount getRoundContrast() {
        return this.roundContrast;
    }

    public void setRoundContrast(NativeRegionSummationElementAmount roundContrast) {
        this.roundContrast = roundContrast;
    }

    public NativeRegionSummationElementAmount getSameContrast() {
        return this.sameContrast;
    }

    public void setSameContrast(NativeRegionSummationElementAmount sameContrast) {
        this.sameContrast = sameContrast;
    }

    public BothSummationCompare getRoundCompare() {
        return this.roundCompare;
    }

    public void setRoundCompare(BothSummationCompare roundCompare) {
        this.roundCompare = roundCompare;
    }

    public BothSummationCompare getSameCompare() {
        return this.sameCompare;
    }

    public void setSameCompare(BothSummationCompare sameCompare) {
        this.sameCompare = sameCompare;
    }

    public StatisticsResultMeta getResultMeta() {
        return this.resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public ForkQueryProcess getProcess() {
        return this.process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }
}

