/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.summation.bean.compare;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import com.mini.framework.util.report.statistics.summation.bean.SummationElementAmount;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class BothSummationCompare
implements OneStatisticsResult {
    private StatisticsResultMeta resultMeta;
    private ForkQueryProcess process;
    private Long contrastCount;
    private Long mainCount;
    private Optional<Double> countRatio;
    private Optional<Long> contrastSum;
    private Optional<Long> mainSum;
    private Optional<Double> sumRatio;

    public static BothSummationCompare createSummationInstance(SummationElementAmount mainSummation, SummationElementAmount contrastSummation) {
        return BothSummationCompare.createCountSumInstance(mainSummation.getCount(), contrastSummation.getCount(), mainSummation.getSum(), contrastSummation.getSum());
    }

    public static BothSummationCompare createCountInstance(Long main, Long contrast) {
        BothSummationCompare instance = new BothSummationCompare();
        instance.mainCount = main;
        instance.contrastCount = contrast;
        instance.countRatio = BothSummationCompare.compareRatio(main, contrast);
        return instance;
    }

    public static BothSummationCompare createCountSumInstance(Long mainCount, Long contrastCount, Long mainSum, Long contrastSum) {
        BothSummationCompare instance = BothSummationCompare.createCountInstance(mainCount, contrastCount);
        instance.mainSum = Optional.ofNullable(mainSum);
        instance.contrastSum = Optional.ofNullable(contrastSum);
        instance.sumRatio = instance.mainSum.isPresent() && instance.contrastSum.isPresent() ? BothSummationCompare.compareRatio(mainSum, contrastSum) : Optional.empty();
        return instance;
    }

    public static Optional<Double> compareRatio(Long main, Long contrast) {
        AssertUtil.assertMethodRequire(main, "main");
        AssertUtil.assertMethodRequire(contrast, "contrast");
        if (contrast > 0L) {
            return Optional.of(1.0 * (double)main.longValue() / (double)contrast.longValue());
        }
        return Optional.empty();
    }

    public Long getContrastCount() {
        return this.contrastCount;
    }

    public BothSummationCompare setContrastCount(Long contrastCount) {
        this.contrastCount = contrastCount;
        return this;
    }

    public Long getMainCount() {
        return this.mainCount;
    }

    public BothSummationCompare setMainCount(Long mainCount) {
        this.mainCount = mainCount;
        return this;
    }

    public Optional<Double> getCountRatio() {
        return this.countRatio;
    }

    public BothSummationCompare setCountRatio(Optional<Double> countRatio) {
        this.countRatio = countRatio;
        return this;
    }

    public Optional<Double> getSumRatio() {
        return this.sumRatio;
    }

    public BothSummationCompare setSumRatio(Optional<Double> sumRatio) {
        this.sumRatio = sumRatio;
        return this;
    }

    public ForkQueryProcess getProcess() {
        return this.process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public StatisticsResultMeta getResultMeta() {
        return this.resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public Optional<Long> getContrastSum() {
        return this.contrastSum;
    }

    public Optional<Long> getMainSum() {
        return this.mainSum;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(this.resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    @Override
    public void clearRedundancyFields() {
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(this.process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }
}

