/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.test;

import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.util.test.TestResourseUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassRelativeResourceLoader;
import org.springframework.core.io.Resource;

public interface TestFileSupport {
    public static String namespaceToPath(String namespace) {
        return namespace.replace(".", "/");
    }

    default public List<String> readThisDirFileLines(String fileName) {
        return TestFileSupport.readFileLines(this.getThisDirFile(fileName));
    }

    default public String readThisDirFileContent(String fileName) {
        return this.readThisDirFileContent(fileName, "\n");
    }

    default public String readThisDirFileContent(String fileName, String lineSplit) {
        return this.readThisDirFileLines(fileName).stream().collect(Collectors.joining(lineSplit));
    }

    default public List<List<String>> getThisDirFilesContent(Predicate<File> predicate) {
        return Stream.of(this.getThisDirFile().listFiles()).filter(File::isFile).filter(predicate).map(TestFileSupport::readFileLines).collect(Collectors.toList());
    }

    public static List<String> readFileLines(File file) {
        try {
            return IOUtils.readLines((Reader)new FileReader(file));
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u6587\u4ef6\u5185\u5bb9:[%s]\u5931\u8d25", new Object[]{file});
        }
    }

    default public List<File> getThisDirFiles(Predicate<File> predicate) {
        return Stream.of(this.getThisDirFile().listFiles()).filter(predicate).collect(Collectors.toList());
    }

    default public List<String> readClasspathFileLines(String classPath, String fileName) {
        return TestFileSupport.readFileLines(this.getClasspathFile(classPath, fileName));
    }

    default public File getClasspathFile(String classPath, String fileName) {
        Resource fileRes = new ClassRelativeResourceLoader(TestResourseUtil.class).getResource("classpath:/" + TestFileSupport.namespaceToPath(classPath) + "/" + fileName);
        try {
            return fileRes.getFile();
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u8bfb\u53d6\u5f53classPath:[%s]\u6587\u4ef6\u5931\u8d25", new Object[]{classPath});
        }
    }

    default public File getThisDirFile() {
        Package pack = this.getClass().getPackage();
        String dirPath = "classpath:/" + TestFileSupport.namespaceToPath(pack.getName());
        Resource dir = new ClassRelativeResourceLoader(TestResourseUtil.class).getResource(dirPath);
        try {
            return dir.getFile();
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u8bfb\u53d6\u5f53\u524d\u7c7b%s\u7684\u540c\u76ee\u5f55\u5931\u8d25", new Object[]{this.getClass(), dir});
        }
    }

    public static Predicate<File> getSuffixPredicate(String suffix) {
        return file -> file.getName().endsWith(suffix);
    }

    default public Function<List<String>, String> listStringToString(String split) {
        return list -> String.join((CharSequence)split, list);
    }

    default public File getThisDirFile(String fileName) {
        return new File(this.getThisDirFile(), fileName);
    }
}

