package com.mini.framework.util.bean;

import java.io.Serializable;

import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.util.string.RegexUtil;
import com.mini.framework.core.exception.HandleEnDeCodeException;

public interface BeanSerializable extends Serializable {
	
	String gsonSerializeTemp = "serializer:Gson,Type:%s,serialize:%s";
	String gsondeserializeRegexTemp = "serializer:Gson,Type:(.*),serialize:(.*)";
	
	default public String serialize() {
		String serialize = GsonUtil.buildMilliSecondDateGson().toJson(this);
		String type = this.getClass().getTypeName();
		return String.format(gsonSerializeTemp, type,serialize);
	}

	default public BeanSerializable deserialize(String serializeStr) throws ClassNotFoundException {
		String[] serializeArr = RegexUtil.getMatch(gsondeserializeRegexTemp, serializeStr, 1,2);
		if(serializeArr==null){
			throw new HandleEnDeCodeException("序列化字段Gson格式不正确:%s", serializeStr);
		}
		Class<BeanSerializable> classOfT = (Class<BeanSerializable>) Class.forName(serializeArr[0]);
		return GsonUtil.buildMilliSecondDateGson().fromJson(serializeArr[1], classOfT );
	}
	
	
	
	public static class SimpleImpl implements BeanSerializable{

		/**
		 * 
		 */
		private static final long serialVersionUID = -3090800397347962318L;
		
	}
}
