package com.mini.framework.util.bean.desc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.util.string.gson.DateMilliSecondSerializer;

/**
 * 可以描述的
 * @author jayheo
 *
 */

public interface Descable {
	

	
	String defaultDescPrefix = "-desc";
	
	default String toJsonWithDesc(){
		return showAttachDescGson(GsonUtil.createBaseBuilder(registerGsonBuilder())).toJson(this);
	}
	
	default Object toObjectWithDesc(){
		String json = toJsonWithDesc();
		return showFitGson().fromJson(json, Map.class);
	}
	
	default UnaryOperator<GsonBuilder> registerGsonBuilder(){
		return UnaryOperator.identity();
	}
	
	default Gson showFitGson(){
		return GsonUtil.buildMilliSecondDateGson(registerGsonBuilder());
	}
	
	static Gson showAttachDescGson(GsonBuilder builder){
		List<Gson> list = new ArrayList<Gson>();
		
		Supplier<Gson> gsonSupplier = ()-> list.get(0);
		builder.registerTypeHierarchyAdapter(Descable.class, new DescSerializer(defaultDescPrefix,gsonSupplier,"未发现描述"));
		Gson gson = builder.create();
		list.add(gson);
		return gson;
	}
	
}
