package com.mini.framework.util.cache;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * SpringRedis 实现时间序列缓存
 * 
 * @author jayheo
 *
 */
public class SpringRedisTimeQueueCache implements TimeQueueCache {
	
	private Logger logger = LogManager.getLogger(SpringRedisTimeQueueCache.class);
	
	private RedisTemplate<String, String> redisTemplate;

	protected String redisPrefix;

	protected String redisKey;
	
	public SpringRedisTimeQueueCache(RedisTemplate<String, String> redisTemplate, String redisPrefix, String redisKey) {
		super();
		this.redisTemplate = redisTemplate;
		this.redisPrefix = redisPrefix;
		this.redisKey = redisKey;
	}

	public String getRedisKey() {
		return redisKey;
	}

	public void setRedisKey(String redisKey) {
		this.redisKey = redisKey;
	}

	public String getRedisPrefix() {
		return redisPrefix;
	}

	public void setRedisPrefix(String redisPrefix) {
		this.redisPrefix = redisPrefix;
	}

	public RedisTemplate<String, String> getRedisTemplate() {
		return redisTemplate;
	}

	public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
		this.redisTemplate = redisTemplate;
	}

	@Override
	public TimeQueueCache write(Date delay, String data) {
		ZSetOperations<String, String> zset = redisTemplate.opsForZSet();
		String key = getCacheKey();
		Boolean success = zset.add(key, data, delay.getTime());
		logger.debug("redis时序队列保存结果:{},保存数据date:{},data:{}",success,delay.getTime(),data);
		return this;
	}

	protected String getCacheKey() {
		AssertUtil.assertSupport(redisPrefix != null, "redis前缀不允许为空");
		return redisPrefix + redisKey;
	}

	@Override
	public List<String> readBefore(Date datePoint) {
		ZSetOperations<String, String> zset = redisTemplate.opsForZSet();
		String key = getCacheKey();
		Set<String> datas = zset.reverseRangeByScore(key, 0, datePoint.getTime());
		int size = datas.size();
		if (size > 0) {
			Long remove = zset.removeRangeByScore(key, 0, datePoint.getTime());
			logger.debug("redis时序队列发现{}条数据取出{}条数据",size,remove);
		}
		// TODO 把顺序调整一下
		return new ArrayList<>(datas);
	}

}
