package com.mini.framework.util.export.protocol;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.util.string.StringUtil;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Date;

/**
 * 内容提供者
 * @author jayheo
 */
public interface ContentSupplier extends ExcelCellContentSupplier{

    /**
     * 是long 型的日期。
     */
    interface DateLong extends ContentSupplier{

        /**
         * 根据long 生成内容
         * @param origin
         * @return
         */
        String supplier(long origin) ;

        @Override
        default String supplier(Object origin) {
            assertNotNull(origin);
            if(origin instanceof Long) {
                return supplier(((Long) origin).longValue());
            }else if(origin instanceof String){
                String originString = (String) origin;
                try{
                    long longValue = Long.parseLong(originString);
                    return supplier(longValue);
                }catch (NumberFormatException e){
                    throw new UnsupportedException("如果是字符串当前只支持能转成long型的数据,数据是:[%s]",origin);
                }
            }else{
                throw new UnsupportedException("当前只支持long型的数据而不是:[%s]型,数据是:[%s]",origin.getClass(),origin);
            }
        }

        public class Full implements DateLong{
            @Override
            public String supplier(long origin) {
                return DateFormatUtils.format(new Date(origin),"yyyy/MM/dd HH:mm:ss");
            }
        }


        public class OnlyDate implements DateLong{
            @Override
            public String supplier(long origin) {
                return DateFormatUtils.format(new Date(origin),"yyyy/MM/dd");
            }
        }

        public class OnlyTime implements DateLong{
            @Override
            public String supplier(long origin) {
                return DateFormatUtils.format(new Date(origin),"HH:mm:ss");
            }
        }
    }


    /**
     * 钱的数字。支持 long 和 int
     */
    interface MoneyNumber extends ContentSupplier{

        /**
         * 从long型得到内容
         * @param origin
         * @return
         */
        String supplier(long origin) ;

        @Override
        default String supplier(Object origin) {
            assertNotNull(origin);
            //TODO origin 变成Long的代码需要抽离出来，做一个叫做findLongFromObject 的方法。
            if(origin instanceof Long) {
                return supplier(((Long) origin).longValue());
            }else if(origin instanceof String){
                String originString = (String) origin;
                try{
                    long longValue = Long.parseLong(originString);
                    return supplier(longValue);
                }catch (NumberFormatException e){
                    throw new UnsupportedException("如果是字符串当前只支持能转成long型的数据,数据是:[%s]",origin);
                }
            }else if(origin instanceof Integer){
                return supplier(((Integer) origin).longValue());
            }else{
                throw new UnsupportedException("当前只支持long和int型的数据而不是:[%s]型,数据是:[%s]",origin.getClass(),origin);
            }
        }


        /**
         * 用分钱储存的元信息
         */
        interface FenOfYuan extends MoneyNumber {

            /**
             * 人民币简体中文<br>
             * 原数据必须是 整数的 不支持小数和非数字
             * <pre>
             *     154154 ->1541.54元
             *     4 ->0.04元
             *     "4" ->0.04元
             * </pre>
             */
            class CnyZhCn implements FenOfYuan {

                @Override
                public String supplier(long origin) {
                    return StringUtil.fen2yuan(origin) + "元";
                }
            }
        }
    }

}
