package com.mini.framework.util.object;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

/**
 * 解决使用Set时提示要实现 equals 和 hashCode 问题
 * @see java.util.Set
 */
public abstract class SetUsefulObject<O extends SetUsefulObject<O>> {

    protected abstract Function<O,Object>[] showHashCodeCells();

    @Override
    public boolean equals(Object other) {
        if (this == other){
            return true;
        }else if(other == null || getClass() != other.getClass()){
            return false;
        }else{
            return Stream.of(showHashCodeCells())
                    .allMatch(fn->Objects.equals(fn.apply((O)this),fn.apply((O)this)));
        }
    }

    @Override
    public int hashCode() {
        Object[] cells = Stream.of(showHashCodeCells()).map(fn -> fn.apply((O) this)).toArray();
        return Objects.hash(cells);
    }
}
