package com.mini.framework.util.oss.bean.work.mark;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.collections4.CollectionUtils;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.work.OssImageWork;
import com.mini.framework.util.oss.bean.work.modify.CircleByRadiusOssImageWork;
import com.mini.framework.util.oss.bean.work.type.OriginType;
import com.mini.framework.util.oss.bean.work.type.WorkActionType;
import com.mini.framework.util.photo.PhotoBodilyFormType;

@Desc("图片水印")
public class ImageMarkOssImageWork extends MarkOssImageWork implements HaveMarkPhotoFrame{

	/**
	 * 图的相对的完整地址
	 */
	@Desc("水印图的相对的完整地址")
	private String image;
	
	@Desc("在做水印前的修改操作")
	private List<OssImageWork> beforeWorks;
	
	/**
	 * 水印希望参数图片的类型
	 */
	@Desc("水印希望参数图片的类型，有这个类型会引导传入的参数")
	private PhotoBodilyFormType frameScheme;

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}
	
	public List<OssImageWork> getBeforeWorks() {
		return beforeWorks;
	}

	public void setBeforeWorks(List<OssImageWork> beforeWorks) {
		this.beforeWorks = beforeWorks;
	}
	
	public PhotoBodilyFormType getFrameScheme() {
		return frameScheme;
	}

	public void setFrameScheme(PhotoBodilyFormType frameScheme) {
		this.frameScheme = frameScheme;
	}

	public ImageMarkOssImageWork addBeforeWorks(OssImageWork... beforeWorks){
		if(this.beforeWorks== null)this.beforeWorks = new ArrayList<>();
		CollectionUtils.addAll(this.beforeWorks,beforeWorks);
		return this;
	}
	
	public List<PhotoBodilyFormType> showFrameSchemes(){
		return Stream.of( frameScheme).filter(Objects::nonNull).collect(Collectors.toList());
	}

	public ImageMarkOssImageWork() {
		super();
	}

	public ImageMarkOssImageWork(String image) {
		super();
		this.image = image;
	}

	public OssImageProcessParams mapperProcessParams(Function<String, String> sureSameBucket){
		//TODO 保证image和主图在同一个bucket
		String image =  sureSameBucket.apply(this.image);
		if(beforeWorks!=null){
			boolean unsopportType = beforeWorks.stream().map(OssImageWork::getWorkType).anyMatch(type->type.matchType(WorkActionType.circleByRadius));
			AssertUtil.assertNoBadReq(!unsopportType, Status.BadReq.unsupportParam, "水印不支持circleByRadius处理需要处理切圆可以走circleByRoundedCorners");
			List<OssImageProcessParams> processes = beforeWorks.stream().map(beforeWork->beforeWork.mapperProcessParams(sureSameBucket)).collect(Collectors.toList());
			image = OssImageProcessParams.applyMultiParams(image, processes);
		}
		return super.mapperProcessParams(sureSameBucket).paramBase64("image", image);
	}
	

	public static List<ImageMarkOssImageWork> createExamples(){
		List<ImageMarkOssImageWork> examples = new ArrayList<ImageMarkOssImageWork>();
		ImageMarkOssImageWork example = new ImageMarkOssImageWork("${这里写图片占位符}");
		example.addBeforeWorks( new CircleByRadiusOssImageWork(30))
		.fillParams(80, OriginType.nw, 100, 500, null)
		.fillParams(14.0,"增加一个图片水印，需要自行修改占位符");
		examples.add(example);
		return examples ;
	}
	
}
