package com.mini.framework.util.store.bean;


/**
 * 有key的
 */
public interface StringKeyable<E> extends Copyable<E> {

    /**
     * 把key显示出来
     * @return
     */
    String showKey();

    /**
     * 是不是匹配key
     * @param other
     * @param <S>
     * @return
     */
    default <S extends StringKeyable<S>> boolean matchKey(S other){
        return matchKey(other.showKey());
    }


    /**
     * 是不是匹配key
     * @param otherKey
     * @param <S>
     * @return
     */
    default <S extends StringKeyable<S>> boolean matchKey(String otherKey){
        return showKey().equals(otherKey);
    }

}
