package com.mini.framework.util.string;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

import com.mini.framework.core.exception.BusyException;

/**
 * @author jayheo
 * 把编码异常消除
 */
public class CharsetUtf8Util {
	
	private static String utf8Charset = "utf-8";

	public static String urlEncode(String param) {
		try {
			return URLEncoder.encode(param, utf8Charset);
		} catch (UnsupportedEncodingException e) {
			throw new BusyException("param:[%s]编码失败", param);
		}
	}

	public static String urlDecode(String param) {
		try {
			return URLDecoder.decode(param, utf8Charset);
		} catch (UnsupportedEncodingException e) {
			throw new BusyException("param:[%s]编码失败", param);
		}
	}
}
