package com.mini.framework.util.string;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.function.FinalUsefulBean;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 占位符工具类
 * @author jayheo
 */
public class PlaceholderVarNameUtil {


    /**
     * 使用占位符替换
     * 按照变量格式
     * */
    public static String replaceForeach(String input, Map<String, String> params, Function<String,String> defaultValueFunction){
        AssertUtil.assertMethodRequire(input,"input");
        return replaceForeach(input, name->Optional.ofNullable(params.get(name)),defaultValueFunction);
    }


    public static String replaceForeach(String input, Map<String, String> params, String defaultValue){
        return replaceForeach(input, name->Optional.ofNullable(params.get(name)),defaultValue);

    }


    public static String replaceForeach(String input, Function<String, Optional<String>> paramFromName, String defaultValue){
        AssertUtil.assertMethodRequire(defaultValue,"defaultValue");
        return replaceForeach(input,paramFromName, key->defaultValue);
    }

    /**
     * 使用占位符替换
     * 按照变量格式
     * */
    public static String replaceForeach(String input, Function<String, Optional<String>> paramFromName, Function<String,String> defaultValueFunction){
        AssertUtil.assertMethodRequire(input,"input");
        AssertUtil.assertMethodRequire(defaultValueFunction,"defaultValueFunction");
        FinalUsefulBean<String> bean = FinalUsefulBean.of(input);
        getPlaceholderMapper(input).forEach((replace,name)->{
            String value = paramFromName.apply(name).orElseGet(()->defaultValueFunction.apply(name));
            bean.apply(v->StringUtils.replace(v,replace,value));
        });
        return bean.get();
    }


    /**
     * 得到占位的所有key
     * 不是${hold} 而是 hold
     * */
    public static Set<String> getPlaceholderKeys(String input){
        return getPlaceholderMapper(input).values().stream().collect(Collectors.toSet());
    }

    /**
     * 得到占位的映射。
     * 例如 key:${hold} value:hold
     * */
    public static Map<String, String> getPlaceholderMapper(String input){
        AssertUtil.assertMethodRequire(input,"input");
        Matcher match = Pattern.compile("\\$\\{([a-zA-Z0-9_]*)\\}").matcher(input);
        Map<String, String> placeholderMapper = new HashMap<>(2);
        while (match.find()) {
            String key = match.group();
            String name = match.group(1);
            placeholderMapper.put(key,name);
        }
        return placeholderMapper;
    }


}
