package com.mini.framework.util.string.gson.deserializer;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.bean.BeanUtil;

public class UnknownTypeInBeanDeserializer<B extends GsonUnknownTypeable<B>>  implements JsonDeserializer<B>,UnknownTypeHelper{

	private Class<B> clazz;
	
	public UnknownTypeInBeanDeserializer(Class<B> clazz) {
		this.clazz = clazz;
	}
	
	@Override
	public B deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
		B instance = null;
		try {
			instance = clazz.newInstance().fromJsonElement(clazz, json);
		} catch (InstantiationException | IllegalAccessException e) {
			throw new ServerException(e, Status.Server.programConfigJava, "创建实例失败:%s",clazz);
		}
		Map<String, Object> map = new HashMap<>();
		fillUnknownValueToMap(json, map );
		List<Field> fields = BeanUtil.getAllField(instance);
		for (Field field : fields) {
			GsonUnknownType type = field.getAnnotation(GsonUnknownType.class);
			if(type!=null){
				Object value = map.get(field.getName());
				try {
					if(value!=null){
						field.setAccessible(true);
						field.set(instance, value);
					}
				} catch (IllegalArgumentException | IllegalAccessException e) {
					throw new ServerException(e, Status.Server.programConfigJava, "异常待说明");
				}
			}
		}
		return instance;
	}

	
}
