package com.mini.framework.util.string.gson.deserializer;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.LinkedTreeMap;

public class UnknownTypeInGsonMapDeserializer implements JsonDeserializer<LinkedTreeMap<String,Object>>,UnknownTypeHelper{

	@Override
	public LinkedTreeMap<String,Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
			throws JsonParseException {
		LinkedTreeMap<String, Object> resultMap = new LinkedTreeMap<>();
        JsonObject jsonObject = json.getAsJsonObject();
        Set<Map.Entry<String, JsonElement>> entrySet = jsonObject.entrySet();
        for (Map.Entry<String, JsonElement> entry : entrySet) {
            resultMap.put(entry.getKey(), entry.getValue());
        }
        fillUnknownValueToMap(json, resultMap);
        return resultMap;
	}

}
