package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;

/**
 * 纸质名片
 * @author jayheo
 *
 */
public class MshowBcardDbto extends DbtoIntEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2288174186928897732L;

	/**
	 * 谁记录的
	 */
	@Insertable(require="纸质名片录入者")
	@Updatable(forbid="纸质名片录入者")
	private Integer ownerId;

	/**
	 * 名字
	 */
	@Insertable(require="纸质名片名字",minLength=2,maxLength=15)
	@Updatable(suffice="纸质名片名字",minLength=2,maxLength=15)
	private String name;

	/**
	 * 电话
	 */
	@Insertable(require="纸质名片电话",minLength=11,maxLength=11)
	@Updatable(forbid="纸质名片电话",minLength=11,maxLength=11)
	private String phone;

	/**
	 * 地址
	 */
	@Updatable(suffice="纸质名片地址",minLength=4)
	private String address;

	/**
	 * 微信号
	 */
	@Updatable(suffice="纸质名片微信",minLength=3,maxLength=35)
	private String weixinNo;

	/**
	 * 公司
	 */
	@Updatable(suffice="纸质名片公司",minLength=4,maxLength=20)
	private String company;

	/**
	 * 职位
	 */
	@Updatable(suffice="纸质名片职位",minLength=2,maxLength=10)
	private String position;

	/**
	 * 被面的照片
	 */
	@Updatable(suffice="纸质名片背面照片")
	private Integer tergalPhotoId;
	
	/**
	 * 正面照片
	 */
	@Insertable(require="纸质名片正面照片")
	@Updatable(suffice="纸质名片正面照片")
	private Integer frontPhotoId;


	public Integer getOwnerId() {
		return ownerId;
	}

	public void setOwnerId(Integer ownerId) {
		this.ownerId = ownerId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getWeixinNo() {
		return weixinNo;
	}

	public void setWeixinNo(String weixinNo) {
		this.weixinNo = weixinNo;
	}

	public String getCompany() {
		return company;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public Integer getTergalPhotoId() {
		return tergalPhotoId;
	}

	public void setTergalPhotoId(Integer tergalPhotoId) {
		this.tergalPhotoId = tergalPhotoId;
	}

	public Integer getFrontPhotoId() {
		return frontPhotoId;
	}

	public void setFrontPhotoId(Integer frontPhotoId) {
		this.frontPhotoId = frontPhotoId;
	}
	
	// 对于名片是有没有点亮什么卡通过另外一个数据来记录

}
