package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;

/**
 * 相册的统计数据
 * @author jayheo
 *
 */
public class SubjectDiaryStatisticsDbto extends DbtoIntEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6149160031081726843L;


	@Insertable(require="日志id")
	@Updatable(forbid="日志id")
	private Integer diaryId;
	
	/**
	 * 标题
	 */
	@Insertable(require="日志标题",minLength=2,maxLength=30)
	@Updatable(suffice="日志标题",minLength=2,maxLength=30)
	private String title;

	
	/**
	 * 作者的用户 id
	 */
	@Insertable(require="相册作者")
	@Updatable(forbid="相册作者")
	private Integer authorId;
	

	/**
	 * 被收藏数
	 */
	@Insertable(require = "被收藏数")
	@Updatable(suffice = "被收藏数")
	private Integer collectedNum;

	/**
	 * 被取消收藏数
	 */
	@Insertable(require = "被取消收藏数")
	@Updatable(suffice = "被取消收藏数")
	private Integer cancelCollectedNum;
	

	/**
	 * 被赞数
	 */
	@Insertable(require = "被赞数")
	@Updatable(suffice = "被赞数")
	private Integer praisedNum;

	/**
	 * 被取消赞数
	 */
	@Insertable(require = "被取消赞数")
	@Updatable(suffice = "被取消赞数")
	private Integer cancelPraisedNum;

	/**
	 * 被浏览数
	 */
	@Insertable(require = "被浏览数")
	@Updatable(suffice = "被浏览数")
	private Integer browsedNum;

	public Integer getDiaryId() {
		return diaryId;
	}

	public void setDiaryId(Integer diaryId) {
		this.diaryId = diaryId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}

	public Integer getCollectedNum() {
		return collectedNum;
	}

	public void setCollectedNum(Integer collectedNum) {
		this.collectedNum = collectedNum;
	}

	public Integer getCancelCollectedNum() {
		return cancelCollectedNum;
	}

	public void setCancelCollectedNum(Integer cancelCollectedNum) {
		this.cancelCollectedNum = cancelCollectedNum;
	}

	public Integer getPraisedNum() {
		return praisedNum;
	}

	public void setPraisedNum(Integer praisedNum) {
		this.praisedNum = praisedNum;
	}

	public Integer getCancelPraisedNum() {
		return cancelPraisedNum;
	}

	public void setCancelPraisedNum(Integer cancelPraisedNum) {
		this.cancelPraisedNum = cancelPraisedNum;
	}

	public Integer getBrowsedNum() {
		return browsedNum;
	}

	public void setBrowsedNum(Integer browsedNum) {
		this.browsedNum = browsedNum;
	}

}
