package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoLongEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.mshow.model.type.SubjectInteractType;
import com.mini.mshow.model.type.SubjectType;

/**
 * 主题与用户的互动
 * 用户对象类型对象id互动类型
 * 
 * @author jayheo
 *
 */
public class SubjectUserInteractDbto extends DbtoLongEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = -297209592342483844L;

	@Insertable(require="互动执行者")
	private Integer actionUserId;

	@Insertable(require="互动主题id")
	private Integer subjectId;

	@Insertable(require="互动主题类型")
	private SubjectType subjectType;
	
	@Insertable(require="互动类型")
	private SubjectInteractType interactType;

	public Integer getActionUserId() {
		return actionUserId;
	}

	public void setActionUserId(Integer actionUserId) {
		this.actionUserId = actionUserId;
	}

	public Integer getSubjectId() {
		return subjectId;
	}

	public void setSubjectId(Integer subjectId) {
		this.subjectId = subjectId;
	}

	public SubjectType getSubjectType() {
		return subjectType;
	}

	public void setSubjectType(SubjectType subjectType) {
		this.subjectType = subjectType;
	}

	public SubjectInteractType getInteractType() {
		return interactType;
	}

	public void setInteractType(SubjectInteractType interactType) {
		this.interactType = interactType;
	}
	

	public SubjectUserInteractDbto() {
		super();
	}

	public SubjectUserInteractDbto(Integer actionUserId, Integer subjectId, SubjectType subjectType,
			SubjectInteractType interactType) {
		super();
		this.actionUserId = actionUserId;
		this.subjectId = subjectId;
		this.subjectType = subjectType;
		this.interactType = interactType;
	}
	
	public static SubjectUserInteractDbto collectDiary(int actionUserId,int diaryId){
		return new SubjectUserInteractDbto(actionUserId, diaryId, SubjectType.diary, SubjectInteractType.collect);
	}
	
	public static SubjectUserInteractDbto collectActivity(int actionUserId,int activityId){
		return new SubjectUserInteractDbto(actionUserId, activityId, SubjectType.activity, SubjectInteractType.collect);
	}

	public static SubjectUserInteractDbto collectAlbum(int actionUserId, int albumId) {
		return new SubjectUserInteractDbto(actionUserId, albumId, SubjectType.album, SubjectInteractType.collect);
	}

	public static SubjectUserInteractDbto collectAlbumPhoto(int actionUserId, int photoId) {
		return new SubjectUserInteractDbto(actionUserId, photoId, SubjectType.photo, SubjectInteractType.collect);
	}

}
