package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.type.FunctionType;

/**
 * 商家自定义的功能
 * @author jayheo
 *
 */
public class CustomFunctionDbto extends DbtoIntEntity{

	/**
	 * 
	 */
	private static final long serialVersionUID = -161312957407419065L;

	/**
	 * 显示的名字
	 */
	@Insertable(require="方法名字",minLength=2,maxLength=6)
	@Updatable(suffice="方法名字",minLength=2,maxLength=6)
	private String name;
	
	/**
	 * logo
	 */
	@Insertable(require="方法logo",minLength=10,maxLength=300)
	@Updatable(suffice="方法logo",minLength=10,maxLength=300)
	private String logo;
	
	/**
	 * logo
	 */
	@Insertable(require="方法不在线的logo",minLength=10,maxLength=300)
	@Updatable(suffice="方法不在线的logo",minLength=10,maxLength=300)
	private String offLinelogo;
	
	/**
	 * 关键值，
	 */
	@Insertable(require="关键值",minLength=4,maxLength=20)
	@Updatable(forbid="关键值")
	private FunctionType key;
	
	/**
	 * 功能的命名空间
	 */
	@Insertable(require="功能的命名空间",minLength=4,maxLength=30)
	@Updatable(suffice="功能的命名空间",minLength=4,maxLength=30)
	private String namespace;
	
	/**
	 * 功能的描述
	 */
	@Insertable(require="功能的描述",minLength=4,maxLength=300)
	@Updatable(suffice="功能的描述",minLength=4,maxLength=300)
	private String desc;
	
	/**
	 * 内容
	 */
	@Insertable(suffice="页面图文视音内容")
	@Updatable(suffice="页面图文视音内容")
	private String mutliContent;
	
	
	/**
	 * 用户首页排序依据
	 */
	@Insertable(require="排序依据")
	@Updatable(suffice="排序依据")
	private Double indexOrder;
	
	/**
	 * 是否上线
	 */
	@Insertable(require="是否上线")
	@Updatable(suffice="是否上线")
	private Boolean online;
	
	/**
	 * 是否显示
	 * number|retail|team等
	 */
	@Insertable(require="是否显示")
	@Updatable(suffice="是否显示")
	private Boolean show;
	
	/**
	 * 使用范围
	 */
	@Insertable(require="使用范围")
	@Updatable(suffice="使用范围")
	private String scope;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public FunctionType getKey() {
		return key;
	}

	public void setKey(FunctionType key) {
		this.key = key;
	}

	public String getNamespace() {
		return namespace;
	}

	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public String getMutliContent() {
		return mutliContent;
	}

	public void setMutliContent(String mutliContent) {
		this.mutliContent = mutliContent;
	}

	public Double getIndexOrder() {
		return indexOrder;
	}

	public void setIndexOrder(Double indexOrder) {
		this.indexOrder = indexOrder;
	}

	public Boolean getOnline() {
		return online;
	}

	public void setOnline(Boolean online) {
		this.online = online;
	}

	public Boolean getShow() {
		return show;
	}

	public void setShow(Boolean show) {
		this.show = show;
	}

	public String getScope() {
		return scope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	public String getOffLinelogo() {
		return offLinelogo;
	}

	public void setOffLinelogo(String offLinelogo) {
		this.offLinelogo = offLinelogo;
	}
	
}
