package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.type.PagePostionType;

/**
 * 页面上的图文视音
 * @author jayheo
 *
 */
public class PagePwvvDbto extends DbtoIntEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8836939215548169754L;

	/**
	 * 内容
	 */
	@Updatable(suffice="页面图文视音内容")
	private String mutliContent;

	/**
	 * 位置
	 */
	@Insertable(require="页面图文视音位置")
	@Updatable(suffice="页面图文视音位置")
	private PagePostionType postion;
	
	@Updatable(suffice="关键值")
	private String key;
	
	
	@Updatable(suffice="名字")
	private String name;

	/**
	 * 方案的索引 同一个东西允许有多个方案，这里是方案的索引
	 */
	@Insertable(require="页面图文视音索引")
	@Updatable(suffice="页面图文视音索引")
	private Integer schemeIndex;
	
	/**
	 * 权重
	 */
	@Insertable(require="页面图文视音权重")
	@Updatable(suffice="页面图文视音权重")
	private Integer weight;

	public String getMutliContent() {
		return mutliContent;
	}

	public void setMutliContent(String mutliContent) {
		this.mutliContent = mutliContent;
	}

	public PagePostionType getPostion() {
		return postion;
	}

	public void setPostion(PagePostionType postion) {
		this.postion = postion;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getSchemeIndex() {
		return schemeIndex;
	}

	public void setSchemeIndex(Integer schemeIndex) {
		this.schemeIndex = schemeIndex;
	}

	public Integer getWeight() {
		return weight;
	}

	public void setWeight(Integer weight) {
		this.weight = weight;
	}
}
