package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;

/**
 * 名片统计数据 对于名片的被收藏次数， 被取消收藏次数， 被浏览次数进行统计， 被分享次数进行统计，
 * 
 * @author jayheo
 *
 */
public class MshowPcardStatisticsDbto extends DbtoIntEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1021596008658608355L;

	/**
	 * 个人名片的id
	 */
	@Insertable(require = "个人名片id")
	@Updatable(forbid = "个人名片id")
	private Integer pcardId;

	/**
	 * 被浏览数
	 */
	@Insertable(require = "被浏览数")
	@Updatable(suffice = "被浏览数")
	private Integer browsedNum;

	/**
	 * 被分享数
	 */
	@Insertable(require = "被分享数")
	@Updatable(suffice = "被分享数")
	private Integer sharedNum;

	/**
	 * 被收藏数
	 */
	@Insertable(require = "被收藏数")
	@Updatable(suffice = "被收藏数")
	private Integer collectedNum;

	/**
	 * 被取消收藏数
	 */
	@Insertable(require = "被取消收藏数")
	@Updatable(suffice = "被取消收藏数")
	private Integer cancelCollectedNum;
	
	
	/**
	 * 这个名片的使用指数，这个指数可以用来做为一个参考
	 * 活跃指数
	 */
	@Insertable(require = "活跃指数")
	@Updatable(suffice = "活跃指数")
	private Integer actionNum;

	public Integer getPcardId() {
		return pcardId;
	}

	public void setPcardId(Integer pcardId) {
		this.pcardId = pcardId;
	}

	public Integer getBrowsedNum() {
		return browsedNum;
	}

	public void setBrowsedNum(Integer browsedNum) {
		this.browsedNum = browsedNum;
	}

	public Integer getSharedNum() {
		return sharedNum;
	}

	public void setSharedNum(Integer sharedNum) {
		this.sharedNum = sharedNum;
	}

	public Integer getCollectedNum() {
		return collectedNum;
	}

	public void setCollectedNum(Integer collectedNum) {
		this.collectedNum = collectedNum;
	}

	public Integer getCancelCollectedNum() {
		return cancelCollectedNum;
	}

	public void setCancelCollectedNum(Integer cancelCollectedNum) {
		this.cancelCollectedNum = cancelCollectedNum;
	}

	public Integer getActionNum() {
		return actionNum;
	}

	public void setActionNum(Integer actionNum) {
		this.actionNum = actionNum;
	}

}
