package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;

/**
 * 活动的统计。
 * 统计点赞数。取消点赞数
 * 统计点赞 数。取消点赞数
 * @author jayheo
 *
 */
public class SubjectActivityStatisticsDbto extends DbtoIntEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6149160031081726843L;


	@Insertable(require="活动id")
	@Updatable(forbid="活动id")
	private Integer activityId;
	
	/**
	 * 标题
	 */
	@Insertable(require="活动标题",minLength=2,maxLength=30)
	@Updatable(suffice="活动标题",minLength=2,maxLength=30)
	private String title;

	
	/**
	 * 作者的用户 id
	 */
	@Insertable(require="活动作者")
	@Updatable(forbid="活动作者")
	private Integer authorId;
	

	/**
	 * 被收藏数
	 */
	@Insertable(require = "被收藏数")
	@Updatable(suffice = "被收藏数")
	private Integer collectedNum;
	
	

	/**
	 * 总被收藏数
	 */
	@Insertable(require = "总被收藏数")
	@Updatable(suffice = "总被收藏数")
	private Integer allCollectedNum;

	/**
	 * 被取消收藏数
	 */
	@Insertable(require = "被取消收藏数")
	@Updatable(suffice = "被取消收藏数")
	private Integer cancelCollectedNum;
	

	/**
	 * 被赞数
	 */
	@Insertable(require = "被赞数")
	@Updatable(suffice = "被赞数")
	private Integer praisedNum;


	/**
	 * 总被赞数
	 */
	@Insertable(require = "总被赞数")
	@Updatable(suffice = "总被赞数")
	private Integer allPraisedNum;
	
	
	/**
	 * 被取消赞数
	 */
	@Insertable(require = "被取消赞数")
	@Updatable(suffice = "被取消赞数")
	private Integer cancelPraisedNum;
	
	/**
	 * 被浏览数
	 */
	@Insertable(require = "被浏览数")
	@Updatable(suffice = "被浏览数")
	private Integer browsedNum;

	public Integer getActivityId() {
		return activityId;
	}

	public void setActivityId(Integer activityId) {
		this.activityId = activityId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}

	public Integer getCollectedNum() {
		return collectedNum;
	}

	public void setCollectedNum(Integer collectedNum) {
		this.collectedNum = collectedNum;
	}

	public Integer getCancelCollectedNum() {
		return cancelCollectedNum;
	}

	public void setCancelCollectedNum(Integer cancelCollectedNum) {
		this.cancelCollectedNum = cancelCollectedNum;
	}

	public Integer getPraisedNum() {
		return praisedNum;
	}

	public void setPraisedNum(Integer praisedNum) {
		this.praisedNum = praisedNum;
	}

	public Integer getCancelPraisedNum() {
		return cancelPraisedNum;
	}

	public void setCancelPraisedNum(Integer cancelPraisedNum) {
		this.cancelPraisedNum = cancelPraisedNum;
	}

	public Integer getBrowsedNum() {
		return browsedNum;
	}

	public void setBrowsedNum(Integer browsedNum) {
		this.browsedNum = browsedNum;
	}

	public Integer getAllCollectedNum() {
		return allCollectedNum;
	}

	public void setAllCollectedNum(Integer allCollectedNum) {
		this.allCollectedNum = allCollectedNum;
	}

	public Integer getAllPraisedNum() {
		return allPraisedNum;
	}

	public void setAllPraisedNum(Integer allPraisedNum) {
		this.allPraisedNum = allPraisedNum;
	}
}
