package com.mini.mshow.model.dbto.site;

import java.util.Date;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.HavePcard;
import com.mini.mshow.model.dbto.able.HavePhone;

public class MshowPcardDbto extends DbtoIntEntity implements HavePhone,HavePcard{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2288174186928897732L;

	private Integer ownerId;
	
	///private String headUrl;

	/**
	 * 复杂的内容
	 */
	@Insertable(require="多媒体内容")
	private String mutliContent;

	/**
	 * 名字
	 */
	@Insertable(require="个人名片名字",minLength=2,maxLength=15)
	@Updatable(suffice="个人名片名字",minLength=2,maxLength=15)
	private String name;
	
	/**
	 * 名片头像，这个数据是冗余的不一定和
	 */
	@Insertable(require="名片头像",minLength=6)
	@Updatable(suffice="名片头像",minLength=6)
	private String headUrl;


	/**
	 * 名字的全拼，用于排序
	 */
	@Insertable(require="名字的全拼",maxLength=30)
	@Updatable(forbid="名字的全拼",maxLength=30)
	private String fullSpell;
	
	/**
	 * 个性签名
	 */
	@Updatable(suffice="个性签名")
	private String sign;
	
	
	/**
	 * 电子邮箱
	 */
	@Updatable(suffice="电子邮箱")
	private String email;
	
	/**
	 * 电话
	 */
	@Insertable(require="个人名片电话",minLength=11,maxLength=11)
	@Updatable(forbid="个人名片电话",minLength=11,maxLength=11)
	private String phone;

	/**
	 * 地址
	 */
	@Updatable(suffice="个人名片地址",minLength=4)
	private String address;

	/**
	 * 微信号
	 */
	@Insertable(require="个人名片微信号",minLength=3,maxLength=35)
	@Updatable(suffice="个人名片微信号",minLength=3,maxLength=35)
	private String weixinNo;

	/**
	 * 公司
	 */
	@Updatable(suffice="个人名片公司",minLength=2,maxLength=20)
	private String company;

	/**
	 * 职位
	 */
	@Updatable(suffice="个人名片职位",minLength=2,maxLength=10)
	private String position;

	/**
	 * 过期的日期
	 */
	@Insertable(require="个人名片过期的日期")
	@Updatable(suffice="个人名片过期的日期")
	private Date expireDate;

	
	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Integer getOwnerId() {
		return ownerId;
	}

	public void setOwnerId(Integer ownerId) {
		this.ownerId = ownerId;
	}

	public String getMutliContent() {
		return mutliContent;
	}

	public void setMutliContent(String mutliContent) {
		this.mutliContent = mutliContent;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getFullSpell() {
		return fullSpell;
	}

	public void setFullSpell(String fullSpell) {
		this.fullSpell = fullSpell;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getWeixinNo() {
		return weixinNo;
	}

	public void setWeixinNo(String weixinNo) {
		this.weixinNo = weixinNo;
	}

	public String getCompany() {
		return company;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public Date getExpireDate() {
		return expireDate;
	}

	public void setExpireDate(Date expireDate) {
		this.expireDate = expireDate;
	}


	public String getHeadUrl() {
		return headUrl;
	}

	public void setHeadUrl(String headUrl) {
		this.headUrl = headUrl;
	}
	
	@Override
	public Integer getPcardId() {
		return getId();
	}
	

	// 对于名片是有没有点亮什么卡通过另外一个数据来记录

}
