package com.mini.mshow.model.dto.multi;

import java.util.Arrays;
import java.util.stream.Stream;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;

public enum MultiContentType {
	words(WordsContent.class), 
	picture(PictureContent.class), 
	video(VideoContent.class),
	subject(SubjectContent.class),
	voice(VoiceContent.class);

	private Class<? extends Content> type;

	MultiContentType(Class<? extends Content> type) {
		this.type = type;
	}

	public Class<? extends Content> getType() {
		return type;
	}

	public static String jsonKey() {
		return "type";
	}

	public static MultiContentType parse(String typeStr) {
		MultiContentType parseType = Stream.of(MultiContentType.values()).filter(type -> type.name().equals(typeStr)).findAny().orElse(null);
		AssertUtil.assertNoBadReq(parseType!=null, Status.BadReq.illParam, "无法解析:[%s]必须为%s的中一个",typeStr,Arrays.toString(MultiContentType.values()));
		return parseType;
	}

	public static MultiContentType typeOf(Class<? extends Content> clazz) {
		MultiContentType type = Stream.of(MultiContentType.values()).filter(contentType ->contentType.getType() .equals(clazz)).findAny().orElse(null);
		AssertUtil.assertSupport(type!=null, "支持类型为%s的内容", clazz);
		return type;
	}
}
