/*
 * Decompiled with CFR 0.152.
 */
package com.mini.mshow.model.dto.multi;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.dto.multi.Content;
import com.mini.mshow.model.dto.multi.PictureContent;
import com.mini.mshow.model.dto.multi.SubjectContent;
import com.mini.mshow.model.dto.multi.VideoContent;
import com.mini.mshow.model.dto.multi.VoiceContent;
import com.mini.mshow.model.dto.multi.WordsContent;
import java.util.Arrays;
import java.util.stream.Stream;

public enum MultiContentType {
    words(WordsContent.class),
    picture(PictureContent.class),
    video(VideoContent.class),
    subject(SubjectContent.class),
    voice(VoiceContent.class);

    private Class<? extends Content> type;

    private MultiContentType(Class<? extends Content> type) {
        this.type = type;
    }

    public Class<? extends Content> getType() {
        return this.type;
    }

    public static String jsonKey() {
        return "type";
    }

    public static MultiContentType parse(String typeStr) {
        MultiContentType parseType = Stream.of(MultiContentType.values()).filter(type -> type.name().equals(typeStr)).findAny().orElse(null);
        AssertUtil.assertNoBadReq((parseType != null ? 1 : 0) != 0, (StatusCode)Status.BadReq.illParam, (String)"\u65e0\u6cd5\u89e3\u6790:[%s]\u5fc5\u987b\u4e3a%s\u7684\u4e2d\u4e00\u4e2a", (Object[])new Object[]{typeStr, Arrays.toString((Object[])MultiContentType.values())});
        return parseType;
    }

    public static MultiContentType typeOf(Class<? extends Content> clazz) {
        MultiContentType type = Stream.of(MultiContentType.values()).filter(contentType -> contentType.getType().equals(clazz)).findAny().orElse(null);
        AssertUtil.assertSupport((type != null ? 1 : 0) != 0, (String)"\u652f\u6301\u7c7b\u578b\u4e3a%s\u7684\u5185\u5bb9", (Object[])new Object[]{clazz});
        return type;
    }
}

