package com.mini.mshow.model.dto.multi;

import java.text.DateFormat;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.json.MilliSecondDateDeserializer;
import com.mini.framework.util.date.json.MilliSecondDateSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class MultiFactory {

	private static Gson gson = buildGson();
	
	private static Gson buildGson() {
		GsonBuilder builder = new GsonBuilder();
		return builder
		.setDateFormat(DateFormat.LONG)
		.registerTypeAdapter(Date.class, new MilliSecondDateSerializer())
		.registerTypeAdapter(Date.class, new MilliSecondDateDeserializer())
		.registerTypeAdapter(Content.class, new ContentDeserializer())
		.registerTypeAdapter(Content.class, new ContentSerializer())
		.create();
	}
	
	public static String toJson(MultiContent multiContent){
		return gson.toJson(multiContent);
	}
	

	public static MultiContent fromJson(String json){
		return gson.fromJson(json, MultiContent.class);
	}
	
	
	/**
	 * 检验multi数据正确性
	 * TODO 对于res 类资源要校验数据源可读性
	 * @param json
	 * @return
	 */
	public static boolean validate(String json){
		AssertUtil.assertNoBadReq(StringUtils.length(json) >=2, Status.BadReq.illParam, "json[%s]长度必须大于2", json);
		fromJson(json);
		return true;
	}
}
