package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.HaveAuthor;
import com.mini.mshow.model.dbto.able.HaveSpecial;


public class SubjectSpecialDbto extends DbtoIntEntity implements HaveAuthor ,HaveSpecial{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6149160031081726843L;

	
	/**
	 * 专题标题
	 */
	@Insertable(require="专题标题",minLength=2,maxLength=30)
	@Updatable(suffice="专题标题",minLength=2,maxLength=30)
	private String title;
	
	/**
	 * 复杂的内容
	 */
	@Insertable(require="多媒体内容",minLength=2)
	@Updatable(suffice="多媒体内容",minLength=2)
	private String mutliContent;
	
	
	/**
	 * 作者的用户 id
	 */
	@Insertable(require="专题作者")
	@Updatable(forbid="专题作者")
	private Integer authorId;
	
	/**
	 * 原创的key，标记这个东西是谁
	 * 这个东西用于在复制的时候记录是谁原创的
	 */
	@Insertable(require="原始作者")
	@Updatable(forbid="原始作者")
	private Integer originalAuthorId;


	public String getTitle() {
		return title;
	}


	public void setTitle(String title) {
		this.title = title;
	}


	public String getMutliContent() {
		return mutliContent;
	}


	public void setMutliContent(String mutliContent) {
		this.mutliContent = mutliContent;
	}


	public Integer getAuthorId() {
		return authorId;
	}


	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}


	public Integer getOriginalAuthorId() {
		return originalAuthorId;
	}


	public void setOriginalAuthorId(Integer originalAuthorId) {
		this.originalAuthorId = originalAuthorId;
	}


	public Integer getSpecialId() {
		return getId();
	}


	@Override
	public Integer showAuthorId() {
		return authorId;
	}


	@Override
	public Integer showSpecialId() {
		return getId();
	}
	
	
	
}
