package com.mini.mshow.model.dbto.site;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;






import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.dto.multi.Content;
import com.mini.mshow.model.dto.multi.MultiContent;
import com.mini.mshow.model.dto.multi.MultiContentType;
import com.mini.mshow.model.dto.multi.PhotoContent;
import com.mini.mshow.model.dto.multi.VideoContent;
import com.mini.mshow.model.dto.multi.WordsContent;
import com.mini.mshow.model.type.SubjectType;

/**
 * 相册/专题/活动的总览概要信息
 * 每个相册/专题/活动都会展示自己的概要
 * 这个数据会从mutliContent中计算出来
 * @author jayheo
 *
 */
public class SubjectOverviewDbto extends DbtoIntEntity{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8942830178819272948L;

	
	public static SubjectOverviewDbto findOverview(MultiContent multiContent){
		AssertUtil.assertMethodRequire(multiContent, "multiContent");
		List<Content> contents = multiContent.getContents();
		SubjectOverviewDbto subjectOverviewDbto = new SubjectOverviewDbto();
		if(contents!=null){
			contents.stream().sorted().forEach(content->{
				MultiContentType type = content.getType();
				switch (type) {
				case photo :
					PhotoContent photo = content.takeContent();
					subjectOverviewDbto.foundPhoto(photo.getResourse());
					break;
				case words :
					if(subjectOverviewDbto.subTitle==null){
						WordsContent words = content.takeContent();
						subjectOverviewDbto.subTitle = words.getWords();
					}
					break;
				case video :
					if(subjectOverviewDbto.subTitle==null){
						VideoContent video = content.takeContent();
						subjectOverviewDbto.videoCoverUrl =video.getCover();
						subjectOverviewDbto.videoUrl =video.getSourse();
					}
					break;

				default:
					break;
				}
			}
			);
		}
		return subjectOverviewDbto;
	}
	

	/**
	 * 这个方法不调用多次
	 * @param photo
	 */
	public void foundImportantPhoto(String photo) {
		AssertUtil.assertMethodRequire(photo, "photo");
		firstPhoto = photo;
		secondPhoto = firstPhoto;
		thirdlyPhoto = secondPhoto;
	}
	
	public int foundPhoto(String photo) {
		AssertUtil.assertMethodRequire(photo, "photo");
		if(firstPhoto==null){
			firstPhoto = photo;
			return 1;
		}else if(secondPhoto==null){
			secondPhoto = photo;
			return 2;
		}else if(thirdlyPhoto==null){
			thirdlyPhoto = photo;
			return 3;
		}else{
			return 0;
		}
	}


	private Map<String, String> fieldDesces = createFieldDesces();
	
	
	
	
	@Insertable(require="互动主题id")
	@Updatable(forbid= "互动主题id")
	private Integer subjectId;

	@Insertable(require="互动主题类型")
	@Updatable(forbid= "互动主题类型")
	private SubjectType subjectType;
	
	/**
	 * 冗余这个主的作者的id
	 */
	@Insertable(require="主题作者id")
	@Updatable(forbid= "主题作者id")
	private Integer subjectAuthorId;

	
	
	/**
	 * 标题
	 */
	@Insertable(require ="标题")
	@Updatable(suffice ="标题")
	private String title;
	
	/**
	 * 子标题
	 */
	@Updatable(suffice ="子标题")
	private String subTitle;
	
	/**
	 * 第一张图片
	 */
	@Updatable(suffice ="第一张图片")
	private String firstPhoto;
	/**
	 * 第二张图片
	 */
	@Updatable(suffice ="第二张图片")
	private String secondPhoto;
	/**
	 * 第三张图片
	 */
	@Updatable(suffice ="第三张图片")
	private String thirdlyPhoto;
	
	/**
	 * 视频的地址
	 */
	@Updatable(suffice ="视频地址")
	private String videoUrl;
	
	/**
	 * 视频的封面地址
	 */
	@Updatable(suffice ="视频封面地址")
	private String videoCoverUrl;

	public String getTitle() {
		return title;
	}

	private Map<String, String> createFieldDesces() {
		Map<String, String> desces = new LinkedHashMap<>();
		desces.put("显示标题和一照片","判断firstPhoto存在且secondPhoto不存在时使用");
		desces.put("显示标题和二照片","判断firstPhoto存在且secondPhoto存在且thirdlyPhoto不存在时使用");
		desces.put("显示标题和三照片","判断firstPhoto存在且secondPhoto存在且thirdlyPhoto存在时使用");
		desces.put("显示标题和子标题","判断存在且subTitle存在时使用");
		desces.put("显示标题和视频","判断videoUrl存在且coverUrl存在时使用");
		desces.put("其它情况","异常一定要把这个打印出来，暂时显示标题");
		return desces ;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getSubTitle() {
		return subTitle;
	}

	public void setSubTitle(String subTitle) {
		this.subTitle = subTitle;
	}

	public String getFirstPhoto() {
		return firstPhoto;
	}

	public void setFirstPhoto(String firstPhoto) {
		this.firstPhoto = firstPhoto;
	}

	public String getSecondPhoto() {
		return secondPhoto;
	}

	public void setSecondPhoto(String secondPhoto) {
		this.secondPhoto = secondPhoto;
	}

	public String getThirdlyPhoto() {
		return thirdlyPhoto;
	}

	public void setThirdlyPhoto(String thirdlyPhoto) {
		this.thirdlyPhoto = thirdlyPhoto;
	}

	public String getVideoUrl() {
		return videoUrl;
	}

	public void setVideoUrl(String videoUrl) {
		this.videoUrl = videoUrl;
	}
	

	public Integer getSubjectId() {
		return subjectId;
	}


	public void setSubjectId(Integer subjectId) {
		this.subjectId = subjectId;
	}


	public SubjectType getSubjectType() {
		return subjectType;
	}


	public void setSubjectType(SubjectType subjectType) {
		this.subjectType = subjectType;
	}


	public Integer getSubjectAuthorId() {
		return subjectAuthorId;
	}


	public void setSubjectAuthorId(Integer subjectAuthorId) {
		this.subjectAuthorId = subjectAuthorId;
	}


	public String getVideoCoverUrl() {
		return videoCoverUrl;
	}


	public void setVideoCoverUrl(String videoCoverUrl) {
		this.videoCoverUrl = videoCoverUrl;
	}


	public void setFieldDesces(Map<String, String> fieldDesces) {
		this.fieldDesces = fieldDesces;
	}


	public Map<String, String> getFieldDesces() {
		return fieldDesces;
	}
}
