package com.mini.mshow.model.dbto.site;

import java.util.Date;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.model.role.write.Writable;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.date.TimeSectionType;
import com.mini.mshow.model.dbto.able.HaveOwner;
import com.mini.mshow.model.dbto.able.HavePcard;
import com.mini.mshow.model.dbto.able.HavePhone;

/**
 * 媒体秀个人名片
 * @author jayheo
 *
 */
public class MshowPcardDbto extends DbtoIntEntity implements HavePhone,HavePcard,HaveOwner{

	private static final String createAccessRole = "createAccess";
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2288174186928897732L;

	/**
	 * 拥有者不可以修改的
	 */
	@Writable(insert={
		@Insertable(require="拥有者id"),
		@Insertable(require="拥有者id",role=createAccessRole)
	})
	@Updatable(forbid="拥有者id")
	private Integer ownerId;
	
	
	/**
	 * 是不是默认名片
	 */
	@Writable(insert={
			@Insertable(require="是默认名片"),
			@Insertable(require="是默认名片",role=createAccessRole)
		})
	@Updatable(suffice="是默认名片")
	private Boolean defaultPcard;
	
	///private String headUrl;

	/**
	 * 复杂的内容
	 */
	@Insertable(require="多媒体内容")
	@Updatable(suffice="多媒体内容")
	private String mutliContent;

	/**
	 * 名字
	 */
	@Insertable(require="个人名片名字",minLength=2,maxLength=15)
	@Updatable(suffice="个人名片名字",minLength=2,maxLength=15)
	private String name;
	
	/**
	 * 名片头像，这个数据是冗余的不一定和
	 */
	@Insertable(require="名片头像",minLength=6)
	@Updatable(suffice="名片头像",minLength=6)
	private String headUrl;


	/**
	 * 名字的全拼，用于排序
	 */
	@Insertable(require="名字的全拼",maxLength=30)
	@Updatable(suffice="名字的全拼",maxLength=30)
	private String fullSpell;
	
	/**
	 * 个性签名
	 */
	@Updatable(suffice="个性签名")
	private String sign;
	
	
	/**
	 * 电子邮箱
	 */
	@Updatable(suffice="电子邮箱")
	private String email;
	
	/**
	 * 电话
	 */
	@Insertable(require="个人名片电话",minLength=11,maxLength=11)
	@Updatable(forbid="个人名片电话",minLength=11,maxLength=11)
	private String phone;

	/**
	 * 地址
	 */
	@Updatable(suffice="个人名片地址",minLength=4)
	private String address;

	/**
	 * 微信号
	 */
	@Insertable(require="个人名片微信号",minLength=3,maxLength=35)
	@Updatable(suffice="个人名片微信号",minLength=3,maxLength=35)
	private String weixinNo;

	/**
	 * 公司
	 */
	@Updatable(suffice="个人名片公司",minLength=2,maxLength=20)
	private String company;

	/**
	 * 职位
	 */
	@Updatable(suffice="个人名片职位",minLength=2,maxLength=10)
	private String position;

	/**
	 * 过期的日期
	 */
	@Writable(insert={
			@Insertable(require="个人名片过期的日期"),
			@Insertable(require="个人名片过期的日期",role=createAccessRole),
	})
	@Updatable(suffice="个人名片过期的日期")
	private Date expireDate;
	
	@Updatable(suffice="简历概述",minLength=8,maxLength=2000)
	private String briefTitle;

	@Updatable(suffice="简历经历")
	private String[] briefThroughs;
	
	/**
	 * TODO 隐藏的策略是什么？
	 * 对陌生人，对发了名片的人？
	 * 需要隐藏的字段用短横线隔开，左右都应该有-
	 * -weixinNo-phone-
	 */
	//@Insertable(require="隐藏的字段")
	//@Updatable(suffice="隐藏的字段")
	private String hideFields;
	
	
	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Integer getOwnerId() {
		return ownerId;
	}

	public void setOwnerId(Integer ownerId) {
		this.ownerId = ownerId;
	}

	public String getMutliContent() {
		return mutliContent;
	}

	public void setMutliContent(String mutliContent) {
		this.mutliContent = mutliContent;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getFullSpell() {
		return fullSpell;
	}

	public void setFullSpell(String fullSpell) {
		this.fullSpell = fullSpell;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getWeixinNo() {
		return weixinNo;
	}

	public void setWeixinNo(String weixinNo) {
		this.weixinNo = weixinNo;
	}

	public String getCompany() {
		return company;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public Date getExpireDate() {
		return expireDate;
	}

	public void setExpireDate(Date expireDate) {
		this.expireDate = expireDate;
	}


	public String getHeadUrl() {
		return headUrl;
	}

	public void setHeadUrl(String headUrl) {
		this.headUrl = headUrl;
	}
	
	public String getBriefTitle() {
		return briefTitle;
	}

	public void setBriefTitle(String briefTitle) {
		this.briefTitle = briefTitle;
	}

	public String[] getBriefThroughs() {
		return briefThroughs;
	}

	public void setBriefThroughs(String[] briefThroughs) {
		this.briefThroughs = briefThroughs;
	}

	public Integer getPcardId() {
		return getId();
	}
	
	public Boolean getDefaultPcard() {
		return defaultPcard;
	}

	public void setDefaultPcard(Boolean defaultPcard) {
		this.defaultPcard = defaultPcard;
	}
	
	public String getHideFields() {
		return hideFields;
	}

	public void setHideFields(String hideFields) {
		this.hideFields = hideFields;
	}

	/**
	 * 判断是不是默认的
	 * @return
	 */
	public boolean ifDefault(){
		return defaultPcard!=null && defaultPcard;
	}

	@Override
	public Integer showPcardId() {
		return getId();
	}

	@Override
	public String showPhone() {
		return phone;
	}

	@Override
	public Integer showOwnerId() {
		return ownerId;
	}
	
	public void valiCreateAccess(){
		valiInsert(createAccessRole);
	}
	
	/**
	 * @param timeSectionType
	 * @param amount
	 */
	public void reletExpireDate(TimeSectionType timeSectionType, Integer amount){
		Date now = new Date();
		expireDate = expireDate==null ||expireDate.before(now)?now:expireDate;
		expireDate = DateUtil.addTimeUnit(timeSectionType, expireDate, amount);
	}
	

	// 对于名片是有没有点亮什么卡通过另外一个数据来记录

}
