package com.mini.mshow.model.dto.multi;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;

/**
 * @author xzh
 * 内容
 */
public abstract class Content implements Comparable<Content>{

	private MultiContentType type;
	/**
	 * 顺序
	 */
	private double order;
	
	public Content() {
		type = MultiContentType.typeOf(this.getClass());
	}
	
	public double getOrder() {
		return order;
	}
	public void setOrder(double order) {
		this.order = order;
	}
	
	public MultiContentType getType() {
		return type;
	}
	public void setType(MultiContentType type) {
		this.type = type;
	}
	
	public boolean matchType(MultiContentType match){
		AssertUtil.assertMethodRequire(match, "match");
		return match.equals(type);
	}
	
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	
	@Override
	public int compareTo(Content other) {
		if(order ==other.order)return 0;
		return order -other.order>0?1:-1;
	}
	
	public <T extends Content> T takeContent(){
		// TODO type不能为空
		String thisClassName = this.getClass().getName();
		String typeClassName =this.getType().getType().getName();
		AssertUtil.assertNoBadReq(thisClassName.equals(typeClassName), Status.BadReq.conflictData, "数据格式错误需要检查:%s",this);
		return (T)this;
	}
	
}
