package com.mini.mshow.model.dto.multi;

import java.text.DateFormat;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.json.MilliSecondDateDeserializer;
import com.mini.framework.util.date.json.MilliSecondDateSerializer;

public class MultiFactory {

	private static final String v3Example1 ="{\"version\":\"v3\",\"title\":\"测试用的\",\"updateDate\":1547949942142,\"contents\":[{\"desc\":\"value代表文本内容 clickLink代表点击跳转的url style代表文字样式包含[important, general, slight] title是手指放上去的title，,clinkSubject优先\",\"style\":\"important\",\"clickLink\":\"https://www.baidu.com\",\"words\":\"知识是人类的认识成果。来自社会实践。其初级形态是经验知识，高级形态是系统科学理论。知识就是概念之间的连结。它是概念的内容的一个方面。概念的内容的另一个方面，就是与直观之间的连结。我们构造概念的目的归根结底是为了把握直观。因此，概念与概念之间必需彼此连结形成知识。有了知识才有力量，才能去把握直观。知识是个体通过与环境相互作用后获得的信息以及组织。按现代认知心理学的理解，知识有广义与狭义之分。广义的知识可以分为两类，即陈述性知识、程序性知识。陈述性知识是描述客观事物的特点及关系的知识，也称为描述性知识。陈述性知识主要包括三种不同水平：符号表征、概念、命题。\",\"title\":\"这是段落的标题\",\"clinkSubject\":{\"subjectType\":\"special\",\"subjectId\":49,\"type\":\"subject\",\"order\":0.7648515940334097},\"type\":\"words\",\"order\":0.4726675822395968},{\"desc\":\"cover代表封面但不一定有 value视频源链接 downUrl代表下载的url，resourse是资源的地址\",\"downUrl\":\"http://vodcdn.video.taobao.com/oss/taobao-ugc/3e8e307f578345f4a7c72bf9691c2ec2/1478606257/video.mp4\",\"sourse\":\"http://vodcdn.video.taobao.com/oss/taobao-ugc/3e8e307f578345f4a7c72bf9691c2ec2/1478606257/video.mp4\",\"cover\":\"http://oss.mooncdn.cn/group1/M00/0C/A1/CqpsflYrHieAHeoQAA2MfetfaVQ861.png\",\"type\":\"video\",\"order\":0.9911628626895009},{\"desc\":\"value代表音频源链接，resourse是资源的地址\",\"resourse\":\"http://zhangmenshiting.qianqian.com/data2/music/f766df899094ea71e51219e471845f74/572596292/572596292.mp3?xcode\\u003de5e2556fc98333c38c3c42cb27c397d9\",\"type\":\"voice\",\"order\":0.6919782266977259},{\"subjectType\":\"special\",\"subjectId\":82,\"type\":\"subject\",\"order\":0.7465957223753753},{\"desc\":\"value代表图片链接 clickLink代表点击跳转的url,clinkSubject优先\",\"clickLink\":\"https://www.baidu.com\",\"resourse\":\"http://oss.mooncdn.cn/group1/M00/0C/A1/CqpsflYrHieAHeoQAA2MfetfaVQ861.png\",\"clinkSubject\":{\"subjectType\":\"album\",\"subjectId\":65,\"type\":\"subject\",\"order\":0.2324940646267779},\"type\":\"photo\",\"order\":0.4158312214234908},{\"desc\":\"value代表文本内容 clickLink代表点击跳转的url style代表文字样式包含[important, general, slight] title是手指放上去的title，,clinkSubject优先\",\"style\":\"general\",\"clickLink\":\"https://www.baidu.com\",\"words\":\"知识是人类的认识成果。来自社会实践。其初级形态是经验知识，高级形态是系统科学理论。知识就是概念之间的连结。它是概念的内容的一个方面。概念的内容的另一个方面，就是与直观之间的连结。我们构造概念的目的归根结底是为了把握直观。因此，概念与概念之间必需彼此连结形成知识。有了知识才有力量，才能去把握直观。知识是个体通过与环境相互作用后获得的信息以及组织。按现代认知心理学的理解，知识有广义与狭义之分。广义的知识可以分为两类，即陈述性知识、程序性知识。陈述性知识是描述客观事物的特点及关系的知识，也称为描述性知识。陈述性知识主要包括三种不同水平：符号表征、概念、命题。\",\"title\":\"这是段落的标题\",\"clinkSubject\":{\"subjectType\":\"activity\",\"subjectId\":4,\"type\":\"subject\",\"order\":0.8121875705264057},\"type\":\"words\",\"order\":0.9811417926436863},{\"desc\":\"cover代表封面但不一定有 value视频源链接 downUrl代表下载的url，resourse是资源的地址\",\"downUrl\":\"http://vodcdn.video.taobao.com/oss/taobao-ugc/3e8e307f578345f4a7c72bf9691c2ec2/1478606257/video.mp4\",\"sourse\":\"http://vodcdn.video.taobao.com/oss/taobao-ugc/3e8e307f578345f4a7c72bf9691c2ec2/1478606257/video.mp4\",\"cover\":\"http://oss.mooncdn.cn/group1/M00/0C/A1/CqpsflYrHieAHeoQAA2MfetfaVQ861.png\",\"type\":\"video\",\"order\":0.596940731450784},{\"subjectType\":\"activity\",\"subjectId\":69,\"type\":\"subject\",\"order\":0.5845079930836549},{\"desc\":\"value代表音频源链接，resourse是资源的地址\",\"resourse\":\"http://zhangmenshiting.qianqian.com/data2/music/f766df899094ea71e51219e471845f74/572596292/572596292.mp3?xcode\\u003de5e2556fc98333c38c3c42cb27c397d9\",\"type\":\"voice\",\"order\":0.7654552660509064},{\"subjectType\":\"special\",\"subjectId\":7,\"type\":\"subject\",\"order\":0.5937823310317278},{\"desc\":\"value代表音频源链接，resourse是资源的地址\",\"resourse\":\"http://zhangmenshiting.qianqian.com/data2/music/f766df899094ea71e51219e471845f74/572596292/572596292.mp3?xcode\\u003de5e2556fc98333c38c3c42cb27c397d9\",\"type\":\"voice\",\"order\":0.8382701678911791},{\"desc\":\"value代表文本内容 clickLink代表点击跳转的url style代表文字样式包含[important, general, slight] title是手指放上去的title，,clinkSubject优先\",\"style\":\"slight\",\"clickLink\":\"https://www.baidu.com\",\"words\":\"知识是人类的认识成果。来自社会实践。其初级形态是经验知识，高级形态是系统科学理论。知识就是概念之间的连结。它是概念的内容的一个方面。概念的内容的另一个方面，就是与直观之间的连结。我们构造概念的目的归根结底是为了把握直观。因此，概念与概念之间必需彼此连结形成知识。有了知识才有力量，才能去把握直观。知识是个体通过与环境相互作用后获得的信息以及组织。按现代认知心理学的理解，知识有广义与狭义之分。广义的知识可以分为两类，即陈述性知识、程序性知识。陈述性知识是描述客观事物的特点及关系的知识，也称为描述性知识。陈述性知识主要包括三种不同水平：符号表征、概念、命题。\",\"title\":\"这是段落的标题\",\"clinkSubject\":{\"subjectType\":\"photo\",\"subjectId\":20,\"type\":\"subject\",\"order\":0.7333488497887951},\"type\":\"words\",\"order\":0.6032742978619063},{\"desc\":\"value代表音频源链接，resourse是资源的地址\",\"resourse\":\"http://zhangmenshiting.qianqian.com/data2/music/f766df899094ea71e51219e471845f74/572596292/572596292.mp3?xcode\\u003de5e2556fc98333c38c3c42cb27c397d9\",\"type\":\"voice\",\"order\":0.4822522043227896},{\"desc\":\"value代表图片链接 clickLink代表点击跳转的url,clinkSubject优先\",\"clickLink\":\"https://www.baidu.com\",\"resourse\":\"http://oss.mooncdn.cn/group1/M00/0C/A1/CqpsflYrHieAHeoQAA2MfetfaVQ861.png\",\"clinkSubject\":{\"subjectType\":\"photo\",\"subjectId\":60,\"type\":\"subject\",\"order\":0.6776887649668528},\"type\":\"photo\",\"order\":0.3185821644842809},{\"subjectType\":\"album\",\"subjectId\":88,\"type\":\"subject\",\"order\":0.5611244138011885}]}"; 
	
	private static Logger logger = LogManager.getLogger(MultiFactory.class);
	
	private static Gson gson = buildGson();
	
	private static Gson buildGson() {
		GsonBuilder builder = new GsonBuilder();
		return builder
		.setDateFormat(DateFormat.LONG)
		.registerTypeAdapter(Date.class, new MilliSecondDateSerializer())
		.registerTypeAdapter(Date.class, new MilliSecondDateDeserializer())
		.registerTypeAdapter(Content.class, new ContentDeserializer())
		.registerTypeAdapter(Content.class, new ContentSerializer())
		.create();
	}
	
	public static String toJson(MultiContent multiContent){
		return gson.toJson(multiContent);
	}
	

	public static MultiContent fromJson(String json){
		return gson.fromJson(json, MultiContent.class);
	}
	
	
	/**
	 * 检验multi数据正确性
	 * TODO 对于res 类资源要校验数据源可读性
	 * @param json
	 * @return
	 */
	public static boolean validate(String json){
		try{
			checkFormat(json);
			return true;
		}catch(Throwable t){
			logger.debug("检查数据格式的时候错误json:{}",json,t);
			return false;
		}
	}
	
	public static void checkFormatIfPresent( String json){
		if(json!=null){
			checkFormat(json);
		}
	}

	public static void checkFormat( String json){
		AssertUtil.assertNoBadReq(StringUtils.length(json) >=2, Status.BadReq.illParam, "json[%s]长度必须大于2", json);
		MultiContent multiContent = fromJson(json);
		AssertUtil.assertNoBadReq(multiContent!=null, Status.BadReq.illParam, "从json中没有解析出MultiContent");
		AssertUtil.assertNoBadReq(multiContent.getContents()!=null, Status.BadReq.illParam, "json中contents不能为空");
		multiContent.getContents().forEach(content->content.takeContent());
	}
	
	
	/**
	 * 显示例子的bean
	 * @param key
	 * @return
	 */
	public static MultiContent exampleBean(String key){
		AssertUtil.assertMethodRequire(key, "key");
		switch (key) {
		case "v3Example1":
			return fromJson(v3Example1);
		}
		return null;
	}
	
}
