package com.mini.mshow.model.dbto.site;

import java.util.Date;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;

/**
 * 媒体秀名片的样式
 * @author jayheo
 *
 */
/**
 * @author jayheo
 *
 */
public class MshowPcardStyleDbto extends DbtoIntEntity implements Comparable<MshowPcardStyleDbto>{

	/**
	 * 
	 */
	private static final long serialVersionUID = 882605523027187733L;
	
	
	/**
	 * 风格名字
	 */
	private String name;
	
	/**
	 * 对这个风格的一个描述
	 */
	private String desc;
	
	/**
	 * 名片的背景图片  底图
	 */
	private String bottomPhoto;
	
	/**
	 * https://help.aliyun.com/document_detail/44976.html?spm=a2c4g.11186623.6.1202.4adf1b76x3dujA
	 * 底图平均颜色
	 */
	private String bottomAverageColor;
	
	/**
	 * 开始时间
	 */
	private Date beginApplyDate;
	
	/**
	 * 结束时间
	 */
	private Date endApplyDate;
	
	/**
	 * 是不是要应用
	 */
	private Boolean applyStatus;
	
	/**
	 * 用户选择时的排列顺序
	 * 这个方便感知顺序对用户选择的影响
	 */
	private Double optionOrder;
	
	
	/**
	 * 是不是默认的选项，
	 * 一般也会有多个默认的选择，根据optionOrder的大小最终确认是哪个
	 */
	private Boolean defaultOption;
	
	//TODO 对一些做得好的模板可以适当收费
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public String getBottomPhoto() {
		return bottomPhoto;
	}

	public void setBottomPhoto(String bottomPhoto) {
		this.bottomPhoto = bottomPhoto;
	}

	public String getBottomAverageColor() {
		return bottomAverageColor;
	}

	public void setBottomAverageColor(String bottomAverageColor) {
		this.bottomAverageColor = bottomAverageColor;
	}

	public Date getBeginApplyDate() {
		return beginApplyDate;
	}

	public void setBeginApplyDate(Date beginApplyDate) {
		this.beginApplyDate = beginApplyDate;
	}

	public Date getEndApplyDate() {
		return endApplyDate;
	}

	public void setEndApplyDate(Date endApplyDate) {
		this.endApplyDate = endApplyDate;
	}

	public Boolean getApplyStatus() {
		return applyStatus;
	}

	public void setApplyStatus(Boolean applyStatus) {
		this.applyStatus = applyStatus;
	}

	public Double getOptionOrder() {
		return optionOrder;
	}

	public void setOptionOrder(Double optionOrder) {
		this.optionOrder = optionOrder;
	}

	public Boolean getDefaultOption() {
		return defaultOption;
	}

	public void setDefaultOption(Boolean defaultOption) {
		this.defaultOption = defaultOption;
	}
	
	public boolean applyStatus(){
		return applyStatus!=null&& applyStatus;
	}
	
	/**
	 * 是不是允许使用
	 * @return
	 */
	public boolean allowApply(){
		long now = System.currentTimeMillis();
		return now>= beginApplyDate.getTime() && now< endApplyDate.getTime() && applyStatus();
	}

	@Override
	public int compareTo(MshowPcardStyleDbto other) {
		return optionOrder.compareTo(other.optionOrder);
	}

}
