package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;

/**
 * 名片统计数据 对于名片的被收藏次数， 被取消收藏次数， 被浏览次数进行统计， 被分享次数进行统计，
 * 
 * @author jayheo
 *
 */
public class MshowPcardStatisticsDbto extends DbtoIntEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1021596008658608355L;

	/**
	 * 个人名片的id
	 */
	@Insertable(require = "个人名片id")
	@Updatable(forbid = "个人名片id")
	private Integer pcardId;
	
	/**
	 * 拥有者不可以修改的
	 */
	@Insertable(require="拥有者id")
	@Updatable(forbid="拥有者id")
	private Integer ownerId;

	/**
	 * 被浏览数
	 */
	@Insertable(require = "被浏览数")
	@Updatable(suffice = "被浏览数")
	private Integer browsedNum;

	/**
	 * 被分享数
	 */
	@Insertable(require = "被分享数")
	@Updatable(suffice = "被分享数")
	private Integer sharedNum;

	/**
	 * 被收藏数
	 */
	@Insertable(require = "被收藏数")
	@Updatable(suffice = "被收藏数")
	private Integer collectedNum;


	/**
	 * 总被收藏数
	 */
	@Insertable(require = "总被收藏数")
	@Updatable(suffice = "总被收藏数")
	private Integer allCollectedNum;
	
	
	/**
	 * 被取消收藏数
	 */
	@Insertable(require = "被取消收藏数")
	@Updatable(suffice = "被取消收藏数")
	private Integer cancelCollectedNum;
	
	
	/**
	 * 这个名片的使用指数，这个指数可以用来做为一个参考
	 * 活跃指数
	 */
	@Insertable(require = "活跃指数")
	@Updatable(suffice = "活跃指数")
	private Integer actionNum;

	public Integer getPcardId() {
		return pcardId;
	}

	public void setPcardId(Integer pcardId) {
		this.pcardId = pcardId;
	}

	public Integer getBrowsedNum() {
		return browsedNum;
	}

	public void setBrowsedNum(Integer browsedNum) {
		this.browsedNum = browsedNum;
	}

	public Integer getSharedNum() {
		return sharedNum;
	}

	public void setSharedNum(Integer sharedNum) {
		this.sharedNum = sharedNum;
	}

	public Integer getCollectedNum() {
		return collectedNum;
	}

	public void setCollectedNum(Integer collectedNum) {
		this.collectedNum = collectedNum;
	}

	public Integer getCancelCollectedNum() {
		return cancelCollectedNum;
	}

	public void setCancelCollectedNum(Integer cancelCollectedNum) {
		this.cancelCollectedNum = cancelCollectedNum;
	}

	public Integer getActionNum() {
		return actionNum;
	}

	public void setActionNum(Integer actionNum) {
		this.actionNum = actionNum;
	}

	public Integer getAllCollectedNum() {
		return allCollectedNum;
	}

	public void setAllCollectedNum(Integer allCollectedNum) {
		this.allCollectedNum = allCollectedNum;
	}
	
	
	public MshowPcardStatisticsDbto() {
	}
	
	/**
	 * 创建一个初始的数据
	 * @param albumId
	 * @param title
	 * @param authorId
	 * @return
	 */
	public static MshowPcardStatisticsDbto createInit(int pcardId,int ownerId) {
		MshowPcardStatisticsDbto init = new MshowPcardStatisticsDbto();
		init.pcardId = pcardId;
		init.ownerId = ownerId;
		return init.initNum();
	}
	
	

	/**
	 * 把所有的相关记录都设置为0
	 * @return
	 */
	public MshowPcardStatisticsDbto initNum() {
		this.sharedNum = 0;
		this.collectedNum = 0;
		this.allCollectedNum = 0;
		this.cancelCollectedNum = 0;
		this.browsedNum = 0;
		this.actionNum = 0;
		return this;
	}

}
