package com.mini.mshow.model.dbto.site;

import java.util.Date;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.mshow.model.type.ReceiveStatusType;

/**
 * 名片发送与接收的记录
 * 为什么要使用int而不是long型，考虑到如果数据量上20亿早已改变存储方式了
 * @author jayheo
 *
 */
public class PcardSendReceiveStatusDbto extends DbtoIntEntity{

	/**
	 * 
	 */
	private static final long serialVersionUID = 464993082287278130L;
	
	/**
	 * 发送人的用户id
	 */
	private Integer sendUserId;
	
	/**
	 * 被发送的名片的拥有者这是一个冗余的数据
	 */
	private Integer sendedPcardOwnerId;
	
	/**
	 * 被发送的名片的id
	 */
	private Integer sendedPcardId;
	
	/**
	 * 接收着的用户id
	 */
	private Integer receiveUserId;
	
	/**
	 * 接收场景下涉及的名片
	 * 比如看到某个人的名片然后发送自己的名片给他们。
	 */
	private Integer receiveScenePcardId;
	
	/**
	 * 接受到名片的状态
	 */
	private ReceiveStatusType status;
	
	/**
	 * 达到接收状态的时间
	 */
	private Date acceptDate;
	
	/**
	 *  达到拒绝 状态的时间
	 */
	private Date refuseDate;
	/**
	 * 达到忽略 状态的时间
	 */
	private Date skipDate;
	
	/**
	 * 达到等待状态的时间
	 */
	private Date sendedDate;

	public Integer getSendUserId() {
		return sendUserId;
	}

	public void setSendUserId(Integer sendUserId) {
		this.sendUserId = sendUserId;
	}

	public Integer getSendedPcardId() {
		return sendedPcardId;
	}

	public void setSendedPcardId(Integer sendedPcardId) {
		this.sendedPcardId = sendedPcardId;
	}

	public Integer getReceiveUserId() {
		return receiveUserId;
	}

	public void setReceiveUserId(Integer receiveUserId) {
		this.receiveUserId = receiveUserId;
	}

	public Integer getReceiveScenePcardId() {
		return receiveScenePcardId;
	}

	public void setReceiveScenePcardId(Integer receiveScenePcardId) {
		this.receiveScenePcardId = receiveScenePcardId;
	}

	public ReceiveStatusType getStatus() {
		return status;
	}

	public void setStatus(ReceiveStatusType status) {
		this.status = status;
	}

	public Date getAcceptDate() {
		return acceptDate;
	}

	public void setAcceptDate(Date acceptDate) {
		this.acceptDate = acceptDate;
	}

	public Date getRefuseDate() {
		return refuseDate;
	}

	public void setRefuseDate(Date refuseDate) {
		this.refuseDate = refuseDate;
	}

	public Date getSkipDate() {
		return skipDate;
	}

	public void setSkipDate(Date skipDate) {
		this.skipDate = skipDate;
	}

	public Date getSendedDate() {
		return sendedDate;
	}

	public void setSendedDate(Date sendedDate) {
		this.sendedDate = sendedDate;
	}

	public Integer getSendedPcardOwnerId() {
		return sendedPcardOwnerId;
	}

	public void setSendedPcardOwnerId(Integer sendedPcardOwnerId) {
		this.sendedPcardOwnerId = sendedPcardOwnerId;
	}
	
}
