package com.mini.mshow.model.dbto.able;

/**
 * 支持收藏数量统计的实体类
 * @author jayheo
 *
 */
public interface SupportCollectStatistics  extends SupportCancelStatistics {

	/**
	 * 得到收藏数(实际收藏的数量，比如有10个人收藏了，但其它3个取消了那么这里是7)
	 * @return
	 */
	public Integer getCollectedNum() ;

	/**
	 * 设置收藏数(实际收藏的数量，比如有10个人收藏了，但其它3个取消了那么这里是7)
	 * @return
	 */
	public void setCollectedNum(Integer collectedNum) ;

	/**
	 * 得到取消收藏数，每次取消收藏的行为都会在这里登记一次
	 * @return
	 */
	public Integer getCancelCollectedNum();

	
	/**
	 * 设置取消收藏数
	 * @return
	 */
	public void setCancelCollectedNum(Integer cancelCollectedNum) ;

	/**
	 * 得到总收藏数(总收藏的数量，比如有10个人收藏了，但其它3个取消了那么这里是10)
	 * @return
	 */
	public Integer getAllCollectedNum() ;

	/**
	 * 设置总收藏数(总收藏的数量，比如有10个人收藏了，但其它3个取消了那么这里是10)
	 * @return
	 */
	public void setAllCollectedNum(Integer allCollectedNum) ;
	
	@Override
	default public void toAtomIncrease(Integer increment){
		valiIncrement(increment);
		setCollectedNum(increment);
		setAllCollectedNum(increment);
	}
	

	@Override
	default public void toAtomCancel(Integer increment){
		valiIncrement(increment);
		setCollectedNum( -increment);
		setCancelCollectedNum( -increment);
	}
}
