package com.mini.mshow.model.dbto.able;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 支持统计的
 * @author jayheo
 *
 */
public interface SupportStatistics {

	/**
	 * 变量原子加1的形式
	 */
	default public void toAtomIncrease(){
		toAtomIncrease(1);
	}
	
	/**
	 * 变量原子加increment的形式
	 * @param increment 需要加的数量
	 */
	public void toAtomIncrease(Integer increment);
	
	default public void valiIncrement(Integer increment){
		AssertUtil.assertMethodRequire(increment, "increment");
		AssertUtil.assertSupport(increment>0, "变量increment:[%s]必须大于0",increment);
	}
	
}
