package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.date.TimeSectionType;
import com.mini.mshow.model.type.VipServerType;
import com.mini.mshow.model.type.WorkStatusType;

/**
 * 使用允许相关的
 * vip服务做为了一个可以购买的商品
 * 
 * @author jayheo
 *
 */
public class AccessVipServerDbto extends DbtoIntEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7481407579812788745L;

	/**
	 * 服务的类型
	 */
	@Insertable(require = "服务的类型")
	@Updatable(forbid = "服务的类型")
	private VipServerType serverType;

	/**
	 * 时间周期的单位 服务的时长是不可以修改的，如果要修改的话可以另外加一个周期
	 */
	@Insertable(require = "服务周期")
	@Updatable(forbid = "服务周期")
	private TimeSectionType periodUnit;

	/**
	 * 周期的长度，比如说三个月，那么这里就是3 服务的时长是不可以修改的，如果要修改的话可以另外加一个周期
	 */
	@Insertable(require = "服务长度")
	@Updatable(forbid = "服务长度")
	private Integer periodCount;

	/**
	 * 服务的标题
	 */
	@Insertable(require = "服务标题")
	@Updatable(suffice = "服务标题")
	private String title;

	/**
	 * vip服务的单价
	 */
	@Insertable(require = "服务价格")
	@Updatable(suffice = "服务价格")
	private Integer price;

	/**
	 * 服务状态 暂停，停止，使用中
	 */
	@Insertable(require = "服务状态")
	@Updatable(suffice = "服务状态")
	private WorkStatusType status;
	
	/**
	 * 在显示给用户看的时候的顺序
	 */
	@Insertable(require = "用户端顺序")
	@Updatable(suffice = "用户端顺序")
	private Double userOrder;
	
	/**
	 * 用户准入的限制
	 * 决定每个人能最多能使用这个权限多少次。
	 */
	@Insertable(require = "用户准入的限制")
	@Updatable(suffice = "用户准入的限制")
	private Integer userAccessLimit;
	
	//TODO 添加一个说明是谁创建的
	
	public TimeSectionType getPeriodUnit() {
		return periodUnit;
	}

	public void setPeriodUnit(TimeSectionType periodUnit) {
		this.periodUnit = periodUnit;
	}

	public Integer getPeriodCount() {
		return periodCount;
	}

	public void setPeriodCount(Integer periodCount) {
		this.periodCount = periodCount;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getPrice() {
		return price;
	}

	public void setPrice(Integer price) {
		this.price = price;
	}

	public VipServerType getServerType() {
		return serverType;
	}

	public void setServerType(VipServerType serverType) {
		this.serverType = serverType;
	}

	public WorkStatusType getStatus() {
		return status;
	}

	public void setStatus(WorkStatusType status) {
		this.status = status;
	}

	public Double getUserOrder() {
		return userOrder;
	}

	public void setUserOrder(Double userOrder) {
		this.userOrder = userOrder;
	}

	public Integer getUserAccessLimit() {
		return userAccessLimit;
	}

	public void setUserAccessLimit(Integer userAccessLimit) {
		this.userAccessLimit = userAccessLimit;
	}
	
	/**
	 * 拼装一个合适的订单名字
	 * @return
	 */
	public String showSimpleOrderName(){
		return  serverType +  title;
	}

}
