package com.mini.mshow.model.dbto.site;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.dbto.able.SupportBrowseStatistics;
import com.mini.mshow.model.dbto.able.SupportCollectStatistics;
import com.mini.mshow.model.dbto.able.SupportPraiseStatistics;
import com.mini.mshow.model.dbto.able.SupportShareStatistics;
import com.mini.mshow.model.type.SubjectInteractType;

/**
 * 专题的统计数据
 * @author jayheo
 *
 */
public class SubjectSpecialStatisticsDbto extends DbtoIntEntity
	implements SupportBrowseStatistics,SupportShareStatistics,SupportPraiseStatistics ,SupportCollectStatistics{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6149160031081726843L;


	@Insertable(require="日志id")
	@Updatable(forbid="日志id")
	private Integer specialId;
	
	/**
	 * 标题
	 */
	@Insertable(require="日志标题",minLength=2,maxLength=30)
	@Updatable(suffice="日志标题",minLength=2,maxLength=30)
	private String title;

	
	/**
	 * 作者的用户 id
	 */
	@Insertable(require="相册作者")
	@Updatable(forbid="相册作者")
	private Integer authorId;
	

	/**
	 * 被收藏数
	 */
	@Insertable(require = "被收藏数")
	@Updatable(suffice = "被收藏数")
	private Integer collectedNum;
	
	

	/**
	 * 总被收藏数
	 */
	@Insertable(require = "总被收藏数")
	@Updatable(suffice = "总被收藏数")
	private Integer allCollectedNum;

	/**
	 * 被取消收藏数
	 */
	@Insertable(require = "被取消收藏数")
	@Updatable(suffice = "被取消收藏数")
	private Integer cancelCollectedNum;
	

	/**
	 * 被赞数
	 */
	@Insertable(require = "被赞数")
	@Updatable(suffice = "被赞数")
	private Integer praisedNum;


	/**
	 * 总被赞数
	 */
	@Insertable(require = "总被赞数")
	@Updatable(suffice = "总被赞数")
	private Integer allPraisedNum;
	
	
	/**
	 * 被取消赞数
	 */
	@Insertable(require = "被取消赞数")
	@Updatable(suffice = "被取消赞数")
	private Integer cancelPraisedNum;

	/**
	 * 被浏览数
	 */
	@Insertable(require = "被浏览数")
	@Updatable(suffice = "被浏览数")
	private Integer browsedNum;
	

	/**
	 * 被分享数
	 */
	@Insertable(require = "被分享数")
	@Updatable(suffice = "被分享数")
	private Integer sharedNum;

	public Integer getSpecialId() {
		return specialId;
	}

	public void setSpecialId(Integer specialId) {
		this.specialId = specialId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}

	public Integer getCollectedNum() {
		return collectedNum;
	}

	public void setCollectedNum(Integer collectedNum) {
		this.collectedNum = collectedNum;
	}

	public Integer getCancelCollectedNum() {
		return cancelCollectedNum;
	}

	public void setCancelCollectedNum(Integer cancelCollectedNum) {
		this.cancelCollectedNum = cancelCollectedNum;
	}

	public Integer getPraisedNum() {
		return praisedNum;
	}

	public void setPraisedNum(Integer praisedNum) {
		this.praisedNum = praisedNum;
	}

	public Integer getCancelPraisedNum() {
		return cancelPraisedNum;
	}

	public void setCancelPraisedNum(Integer cancelPraisedNum) {
		this.cancelPraisedNum = cancelPraisedNum;
	}

	public Integer getBrowsedNum() {
		return browsedNum;
	}

	public void setBrowsedNum(Integer browsedNum) {
		this.browsedNum = browsedNum;
	}

	public Integer getAllCollectedNum() {
		return allCollectedNum;
	}

	public void setAllCollectedNum(Integer allCollectedNum) {
		this.allCollectedNum = allCollectedNum;
	}

	public Integer getAllPraisedNum() {
		return allPraisedNum;
	}

	public void setAllPraisedNum(Integer allPraisedNum) {
		this.allPraisedNum = allPraisedNum;
	}
	

	public Integer getSharedNum() {
		return sharedNum;
	}

	public void setSharedNum(Integer sharedNum) {
		this.sharedNum = sharedNum;
	}

	public SubjectSpecialStatisticsDbto() {
		super();
	}

	/**
	 * 创建一个初始的数据
	 * @param albumId
	 * @param title
	 * @param authorId
	 * @return
	 */
	public static SubjectSpecialStatisticsDbto createInit(Integer specialId, String title, Integer authorId) {
		SubjectSpecialStatisticsDbto init = new SubjectSpecialStatisticsDbto();
		init.specialId = specialId;
		init.title = title;
		init.authorId = authorId;
		return init.initNum();
	}

	/**
	 * 把所有的相关记录都设置为0
	 * @return
	 */
	public SubjectSpecialStatisticsDbto initNum() {
		this.collectedNum = 0;
		this.allCollectedNum = 0;
		this.cancelCollectedNum = 0;
		this.praisedNum = 0;
		this.allPraisedNum = 0;
		this.cancelPraisedNum = 0;
		this.browsedNum = 0;
		this.sharedNum = 0;
		return this;
	}
	
	
	
	/**
	 * 检查是不是支持这个统计
	 * @param interactType
	 * @return
	 */
	public static boolean supportStatistics(SubjectInteractType interactType){
		AssertUtil.assertMethodRequire(interactType, "interactType");
		return Stream.of(SubjectInteractType.browse,SubjectInteractType.share,SubjectInteractType.collect,SubjectInteractType.praise).collect(Collectors.toSet()).contains(interactType);	
	}

	/**
	 * 同过互动
	 * @param interactType
	 * @param cancel false代表取消，true代表添加关系
	 * @return
	 */
	public static SubjectSpecialStatisticsDbto createAtomByInteract(SubjectInteractType interactType, boolean cancel) {
		AssertUtil.assertMethodRequire(interactType, "interactType");
		SubjectSpecialStatisticsDbto atom = new SubjectSpecialStatisticsDbto();
		switch(interactType){
			case browse:
				atom.atomIncreaseBrowse();
				break;
			case share:
				atom.atomIncreaseShare();
				break;
			case collect:
				atom.atomSwitchCollect(cancel);
				break;
			case praise:
				atom.atomSwitchPraise(cancel);
				break;
			default:
				throw new UnsupportedException("活动暂时不是支持%s的增量", interactType);
		}
		return atom;
	}
}
