package com.mini.mshow.model.dbto.site;

import java.util.Date;

import com.mini.framework.core.status.Status;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateStringFormatInc;
import com.mini.mshow.model.type.ProductType;
import com.mini.mshow.model.type.TradeStatusType;
import com.mini.mshow.model.type.UseStatusType;

/**
 * 使用允许相关的
 * 交易的订单
 * @author jayheo
 *
 */
public class AccessTradeProductOrderDbto extends DbtoIntEntity{

/**
	 * 
	 */
	private static final long serialVersionUID = -1850530981333135386L;

	/**
	 * 产品的类型
	 */
	private ProductType productType;
	

	/**
	 * 产品的id
	 */
	private Integer productId;
	
	/**
	 * 产品当时的名字
	 */
	private String productName;
	
	/**
	 * 付款金额
	 */
	private Integer payMoney;
	
	/**
	 * 付款人
	 */
	private Integer payUserId;
	
	/**
	 * 付款日期
	 */
	private Date payDate;
	
	/**
	 * 订单号
	 */
	private String orderNo;
	
	/**
	 * 付款状态
	 */
	private TradeStatusType payStatus;
	
	/**
	 * 使用状态
	 */
	private UseStatusType useStatus; 

	
	public ProductType getProductType() {
		return productType;
	}

	public void setProductType(ProductType productType) {
		this.productType = productType;
	}

	public Integer getProductId() {
		return productId;
	}

	public void setProductId(Integer productId) {
		this.productId = productId;
	}

	public Integer getPayMoney() {
		return payMoney;
	}

	public void setPayMoney(Integer payMoney) {
		this.payMoney = payMoney;
	}

	public Integer getPayUserId() {
		return payUserId;
	}

	public void setPayUserId(Integer payUserId) {
		this.payUserId = payUserId;
	}

	public Date getPayDate() {
		return payDate;
	}

	public void setPayDate(Date payDate) {
		this.payDate = payDate;
	}

	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public TradeStatusType getPayStatus() {
		return payStatus;
	}

	public void setPayStatus(TradeStatusType payStatus) {
		this.payStatus = payStatus;
	}
	
	public UseStatusType getUseStatus() {
		return useStatus;
	}

	public void setUseStatus(UseStatusType useStatus) {
		this.useStatus = useStatus;
	}
	
	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	/**
	 * 使用这个订单权限
	 * 也未使用状态变成已使用。
	 * 如果是已使用状态会抛出异常
	 * @return
	 */
	public AccessTradeProductOrderDbto useAccess(){
		AssertUtil.assertPermission(UseStatusType.unused.equals(useStatus), Status.Permission.forbid, "订单不是可用状态而是%s状态", useStatus);
		AccessTradeProductOrderDbto newStatus = new AccessTradeProductOrderDbto();
		newStatus.setUseStatus(UseStatusType.used);
		return newStatus;
	}

	public static DateStringFormatInc createProductOrder(){
		//ding product 产吕订单号
		return new  DateStringFormatInc("DP%s", "yyyyMMddHHmmss");
	}
	
	
}
