package com.mini.mshow.model.type;

import java.util.stream.Stream;

import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.weixin.pay.model.PayStatusType;
import com.mini.framework.util.asserts.AssertUtil;

/**
 * 交易的状态
 * 
 * @author jayheo
 *
 */
public enum TradeStatusType {

	/**
	 * 申请中的状态
	 */
	apply(PayStatusType.paying),
	/**
	 * 拒绝状态
	 */
	refuse(PayStatusType.fail),
	/**
	 * 已接受状态
	 */
	accept(PayStatusType.success);

	private PayStatusType mapPayStatus;

	private TradeStatusType(PayStatusType mapPayStatus) {
		this.mapPayStatus = mapPayStatus;
	}

	public static TradeStatusType mapStatus(PayStatusType payStatus) {
		AssertUtil.assertMethodRequire(payStatus, "payStatus");
		return Stream.of(TradeStatusType.values()).filter(status->status.mapPayStatus.equals(payStatus)).findFirst()
				//如果这里出现问题，要去改一下映射
				.orElseThrow(()-> new BusyException(Status.Busy.fatalBug, "找不到支持状态:[%s]对应的交易状态", payStatus));
	}

}
