/*
 * Decompiled with CFR 0.152.
 */
package com.mini.mshow.model.dbto.site;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.model.role.write.Writable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.date.TimeSectionType;
import com.mini.framework.util.string.PinyinUtil;
import com.mini.mshow.model.dbto.able.HaveOwner;
import com.mini.mshow.model.dbto.able.HavePcard;
import com.mini.mshow.model.dbto.able.HavePhone;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class MshowPcardDbto
extends DbtoIntEntity
implements HavePhone,
HavePcard,
HaveOwner {
    private static final String createAccessRole = "createAccess";
    private static final long serialVersionUID = 2288174186928897732L;
    @Writable(insert={@Insertable(require="\u62e5\u6709\u8005id"), @Insertable(require="\u62e5\u6709\u8005id", role="createAccess")})
    @Updatable(forbid="\u62e5\u6709\u8005id")
    private Integer ownerId;
    @Insertable(require="\u591a\u5a92\u4f53\u5185\u5bb9")
    @Updatable(suffice="\u591a\u5a92\u4f53\u5185\u5bb9")
    private String multiContent;
    @Insertable(require="\u4e2a\u4eba\u540d\u7247\u540d\u5b57", minLength=2, maxLength=15)
    @Updatable(suffice="\u4e2a\u4eba\u540d\u7247\u540d\u5b57", minLength=2, maxLength=15)
    private String name;
    @Insertable(require="\u540d\u7247\u5934\u50cf", minLength=6)
    @Updatable(suffice="\u540d\u7247\u5934\u50cf", minLength=6)
    private String headUrl;
    @Insertable(require="\u540d\u5b57\u7684\u5168\u62fc", maxLength=30)
    @Updatable(suffice="\u540d\u5b57\u7684\u5168\u62fc", maxLength=30)
    private String fullSpell;
    @Updatable(suffice="\u4e2a\u6027\u7b7e\u540d")
    private String sign;
    @Updatable(suffice="\u7535\u5b50\u90ae\u7bb1")
    private String email;
    @Insertable(require="\u4e2a\u4eba\u540d\u7247\u7535\u8bdd", minLength=11, maxLength=11)
    @Updatable(suffice="\u4e2a\u4eba\u540d\u7247\u7535\u8bdd", minLength=11, maxLength=11)
    private String phone;
    @Updatable(suffice="\u4e2a\u4eba\u540d\u7247\u5730\u5740", minLength=4)
    private String address;
    @Updatable(suffice="\u5730\u5740GPS")
    private String addressGps;
    @Insertable(require="\u4e2a\u4eba\u540d\u7247\u5fae\u4fe1\u53f7", minLength=3, maxLength=35)
    @Updatable(suffice="\u4e2a\u4eba\u540d\u7247\u5fae\u4fe1\u53f7", minLength=3, maxLength=35)
    private String weixinNo;
    @Updatable(suffice="\u4e2a\u4eba\u540d\u7247\u516c\u53f8", minLength=2, maxLength=20)
    private String company;
    @Updatable(suffice="\u4e2a\u4eba\u540d\u7247\u804c\u4f4d", minLength=2, maxLength=10)
    private String position;
    @Writable(insert={@Insertable(require="\u4e2a\u4eba\u540d\u7247\u8fc7\u671f\u7684\u65e5\u671f"), @Insertable(require="\u4e2a\u4eba\u540d\u7247\u8fc7\u671f\u7684\u65e5\u671f", role="createAccess")})
    @Updatable(suffice="\u4e2a\u4eba\u540d\u7247\u8fc7\u671f\u7684\u65e5\u671f")
    private Date expireDate;
    @Updatable(suffice="\u7b80\u5386\u6982\u8ff0", minLength=8, maxLength=2000)
    private String briefTitle;
    @Updatable(suffice="\u540d\u7247\u98ce\u683cid")
    private Integer styleId;
    @Updatable(suffice="\u624b\u673a\u9690\u79c1\u4fdd\u62a4")
    @Insertable(require="\u624b\u673a\u9690\u79c1\u4fdd\u62a4")
    private Boolean privatePhone;
    @Updatable(suffice="\u516c\u53f8\u804c\u4f4d\u9690\u79c1\u4fdd\u62a4")
    @Insertable(require="\u516c\u53f8\u804c\u4f4d\u9690\u79c1\u4fdd\u62a4")
    private Boolean privateWork;
    @Updatable(suffice="\u5fae\u4fe1\u53f7\u9690\u79c1\u4fdd\u62a4")
    @Insertable(require="\u5fae\u4fe1\u53f7\u9690\u79c1\u4fdd\u62a4")
    private Boolean privateWeixin;

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    public String getMultiContent() {
        return this.multiContent;
    }

    public void setMultiContent(String multiContent) {
        this.multiContent = multiContent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullSpell() {
        return this.fullSpell;
    }

    public void setFullSpell(String fullSpell) {
        this.fullSpell = fullSpell;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddressGps() {
        return this.addressGps;
    }

    public void setAddressGps(String addressGps) {
        this.addressGps = addressGps;
    }

    public String getWeixinNo() {
        return this.weixinNo;
    }

    public void setWeixinNo(String weixinNo) {
        this.weixinNo = weixinNo;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public String getHeadUrl() {
        return this.headUrl;
    }

    public void setHeadUrl(String headUrl) {
        this.headUrl = headUrl;
    }

    public String getBriefTitle() {
        return this.briefTitle;
    }

    public void setBriefTitle(String briefTitle) {
        this.briefTitle = briefTitle;
    }

    public Integer getPcardId() {
        return this.getId();
    }

    public Integer getStyleId() {
        return this.styleId;
    }

    public void setStyleId(Integer styleId) {
        this.styleId = styleId;
    }

    public Boolean getPrivatePhone() {
        return this.privatePhone;
    }

    public void setPrivatePhone(Boolean privatePhone) {
        this.privatePhone = privatePhone;
    }

    public Boolean getPrivateWork() {
        return this.privateWork;
    }

    public void setPrivateWork(Boolean privateWork) {
        this.privateWork = privateWork;
    }

    public Boolean getPrivateWeixin() {
        return this.privateWeixin;
    }

    public void setPrivateWeixin(Boolean privateWeixin) {
        this.privateWeixin = privateWeixin;
    }

    public boolean ifPrivatePhone() {
        return this.privatePhone != null && this.privatePhone != false;
    }

    public boolean ifPrivateWeixin() {
        return this.privateWeixin != null && this.privateWeixin != false;
    }

    public boolean ifPrivateWork() {
        return this.privateWork != null && this.privateWork != false;
    }

    public MshowPcardDbto applyPrivateFor(Integer targetUserId) {
        if (targetUserId == null || targetUserId.equals(this.showOwnerId())) {
            this.applyPrivate();
        }
        return this;
    }

    public MshowPcardDbto applyPrivate() {
        if (this.ifPrivatePhone()) {
            this.phone = null;
        }
        if (this.ifPrivateWeixin()) {
            this.weixinNo = null;
        }
        if (this.ifPrivateWork()) {
            this.company = null;
            this.position = null;
        }
        return this;
    }

    public int showUseStyleId(Supplier<Integer> defaultSupplier) {
        Integer id = this.styleId;
        if (id == null) {
            id = defaultSupplier.get();
        }
        AssertUtil.assertNotFatal((id != null ? 1 : 0) != 0, (StatusCode)Status.Busy.dataUnConfigSite, (String)"\u6ca1\u6709\u627e\u5230\u9ed8\u8ba4\u7684\u540d\u7247\u6837\u5f0f", (Object[])new Object[0]);
        return id;
    }

    @Override
    public Integer showPcardId() {
        return this.getId();
    }

    @Override
    public String showPhone() {
        return this.phone;
    }

    @Override
    public Integer showOwnerId() {
        return this.ownerId;
    }

    public void valiCreateAccess() {
        this.valiInsert(createAccessRole);
    }

    public Date reletExpireDate(TimeSectionType timeSectionType, Integer amount) {
        Date now = new Date();
        Date newExpireDate = this.expireDate == null || this.expireDate.before(now) ? now : this.expireDate;
        newExpireDate = DateUtil.addTimeUnit((TimeSectionType)timeSectionType, (Date)newExpireDate, (int)amount);
        newExpireDate = DateUtil.getCleanedTauchDateUnit((TimeSectionType)TimeSectionType.day, (Date)newExpireDate);
        return newExpireDate;
    }

    public void trySetPinyin() {
        if (this.name != null) {
            this.fullSpell = PinyinUtil.toFirstPinyin((String)this.name);
            this.fullSpell = StringUtils.substring((String)this.fullSpell, (int)0, (int)30);
        }
    }

    public void skipMulti() {
        this.setMultiContent(null);
    }
}

