/*
 * Decompiled with CFR 0.152.
 */
package com.mini.mshow.model.type;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.trace.model.type.ActionBehaviourType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SubjectInteractType {
    browse("\u6d4f\u89c8"),
    share("\u5206\u4eab"),
    collect("\u6536\u85cf"),
    praise("\u70b9\u8d5e"),
    copyFrom("\u590d\u5236\u6e90\u7aef"),
    copyAs("\u590d\u5236\u7ed3\u679c");

    private String title;

    private SubjectInteractType(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static List<SubjectInteractType> canCancelTypes() {
        return Stream.of(collect, praise).collect(Collectors.toList());
    }

    public boolean canCancel() {
        return SubjectInteractType.canCancelTypes().contains((Object)this);
    }

    public ActionBehaviourType tryMapBehaviour() {
        try {
            return this.mapBehaviour();
        }
        catch (UnsupportedException e) {
            return null;
        }
    }

    public ActionBehaviourType mapBehaviour() {
        switch (this) {
            case browse: {
                return ActionBehaviourType.browse;
            }
            case collect: {
                return ActionBehaviourType.collect;
            }
            case praise: {
                return ActionBehaviourType.praise;
            }
            case share: {
                return ActionBehaviourType.share;
            }
        }
        throw new UnsupportedException("\u627e\u4e0d\u5230\u4e0e:[%s]\u5339\u914d\u7684\u884c\u4e3a", new Object[]{this});
    }
}

