package com.mini.mshow.model.dbto.able;

/**
 * 支持收藏数量统计的实体类
 * @author jayheo
 *
 */
public interface SupportCollectStatistics  extends SupportCancelStatistics {

	/**
	 * 得到收藏数(实际收藏的数量，比如有10个人收藏了，但其它3个取消了那么这里是7)
	 * @return
	 */
	public Integer getCollectedNum() ;

	/**
	 * 设置收藏数(实际收藏的数量，比如有10个人收藏了，但其它3个取消了那么这里是7)
	 * @return
	 */
	public void setCollectedNum(Integer collectedNum) ;

	/**
	 * 得到取消收藏数，每次取消收藏的行为都会在这里登记一次
	 * @return
	 */
	public Integer getCancelCollectedNum();

	
	/**
	 * 设置取消收藏数
	 * @return
	 */
	public void setCancelCollectedNum(Integer cancelCollectedNum) ;

	/**
	 * 得到总收藏数(总收藏的数量，比如有10个人收藏了，但其它3个取消了那么这里是10)
	 * @return
	 */
	public Integer getAllCollectedNum() ;

	/**
	 * 设置总收藏数(总收藏的数量，比如有10个人收藏了，但其它3个取消了那么这里是10)
	 * @return
	 */
	public void setAllCollectedNum(Integer allCollectedNum) ;
	
	
	
	
	default public void atomSwitchCollect(boolean cancel){
		atomSwitchCollect(cancel, 1);
	}
	
	
	default public void atomSwitchCollect(boolean cancel,Integer increment){
		if(cancel){
			atomCancelCollect(increment);
		}else{
			atomIncreaseCollect(increment);
		}
	}
	
	default public void atomIncreaseCollect(){
		atomIncreaseCollect(1);
	}
	
	default public void atomIncreaseCollect(Integer increment){
		valiIncrement(increment);
		setCollectedNum(increment);
		setAllCollectedNum(increment);
	}
	

	default public void atomCancelCollect(){
		atomCancelCollect(1);
	}
	
	default public void atomCancelCollect(Integer increment){
		valiIncrement(increment);
		setCollectedNum( -increment);
		setCancelCollectedNum( increment);
	}
}
