package com.mini.mshow.model.dbto.site;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.HaveAlbum;
import com.mini.mshow.model.dbto.able.HaveAuthor;
import com.mini.mshow.model.dbto.able.HaveSorter;
import com.mini.mshow.model.dbto.able.IsOneSubject;
import com.mini.mshow.model.type.SubjectType;

public class SubjectAlbumDbto extends DbtoIntEntity implements HaveAlbum,HaveAuthor,HaveSorter,IsOneSubject{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6149160031081726843L;

	
	
	/**
	 * 在主题中找到总览数据
	 * @param headPhotosGetter
	 * @return
	 */
	public SubjectOverviewDbto tryFindOverview(Function<Integer, List<SubjectAlbumPhotoDbto>> headPhotosGetter){
		SubjectOverviewDbto overview = new SubjectOverviewDbto();
		List<SubjectAlbumPhotoDbto> photos = headPhotosGetter.apply(getId());
		overview.fillImportantPhoto(photos.stream().map(SubjectAlbumPhotoDbto::showRealPhoto).collect(Collectors.toList()).toArray(new String[]{}));
		//TODO 这里还要提供一个方式拿到某个视频
		overview.setTitle(title);
		return overview.fillSubjectField(this);
	}
	
	
	
	/**
	 * 相册标题
	 */
	@Insertable(require="相册标题",minLength=2,maxLength=500)
	@Updatable(suffice="相册标题",minLength=2,maxLength=500)
	private String title;


	/**
	 * 拥有者id 冗余这个数字反正不会变的
	 * 也就是作者
	 */
	@Insertable(require="相册的作者")
	@Updatable(forbid="相册的作者")
	private Integer authorId;
	
	
	
	/**
	 * 原创的key，标记这个东西是谁
	 * 这个东西用于在复制的时候记录是谁原创的
	 */
	@Insertable(require="原始作者")
	@Updatable(forbid="原始作者")
	private Integer originalAuthorId;

	/**
	 * 统计相片数量，这也是一个计算出来的数字
	 * 在相片添加和删除的时候应该修改一下这里。
	 */
	@Insertable(require="相片的数量")
	@Updatable(suffice="相片的数量")
	private Integer count;
	
	/**
	 * 每个相册可以有一个封面
	 */
	@Updatable(suffice="相册封面")
	private String cover;
	
	
	/**
	 * 由用户设置的封面相片id
	 * 这个不一定有，一般来说，如果用户设置了以后就会走用户设置的，否则系统自由算
	 */
	@Updatable(suffice="相册封面相片id")
	private Integer coverPhotoId;
	
	/**
	 * 排序器
	 * 一般来说新的相册默认放在最前面。
	 */
	@Insertable(require="排序器")
	@Updatable(suffice="排序器")
	private Double sorter;
	
	
	//TODO 要把标签值和标签数弄出来

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}

	public Integer getCount() {
		return count;
	}

	public void setCount(Integer count) {
		this.count = count;
	}

	public Integer getOriginalAuthorId() {
		return originalAuthorId;
	}

	public void setOriginalAuthorId(Integer originalAuthorId) {
		this.originalAuthorId = originalAuthorId;
	}

	public String getCover() {
		return cover;
	}

	public void setCover(String cover) {
		this.cover = cover;
	}

	public Integer getCoverPhotoId() {
		return coverPhotoId;
	}

	public void setCoverPhotoId(Integer coverPhotoId) {
		this.coverPhotoId = coverPhotoId;
	}

	public Double getSorter() {
		return sorter;
	}

	public void setSorter(Double sorter) {
		this.sorter = sorter;
	}

	@Override
	public Integer showAlbumId() {
		return getId();
	}

	@Override
	public Integer showAuthorId() {
		return authorId;
	}

	@Override
	public Double showSorter() {
		return sorter;
	}

	@Override
	public SubjectType showSubectType() {
		return SubjectType.album;
	}

	@Override
	public Integer showSubjectId() {
		return getId();
	}
	
	

}
