/*
 * Decompiled with CFR 0.152.
 */
package com.mini.mshow.model.type;

import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.weixin.pay.model.PayStatusType;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.stream.Stream;

public enum TradeStatusType {
    apply(PayStatusType.paying),
    refuse(PayStatusType.fail),
    accept(PayStatusType.success),
    refunding(PayStatusType.refund);

    private PayStatusType mapPayStatus;

    private TradeStatusType(PayStatusType mapPayStatus) {
        this.mapPayStatus = mapPayStatus;
    }

    public static TradeStatusType mapStatus(PayStatusType payStatus) {
        AssertUtil.assertMethodRequire((Object)payStatus, (String)"payStatus");
        return Stream.of(TradeStatusType.values()).filter(status -> status.mapPayStatus.equals((Object)payStatus)).findFirst().orElseThrow(() -> new BusyException(Status.Busy.fatalBug, "\u627e\u4e0d\u5230\u652f\u6301\u72b6\u6001:[%s]\u5bf9\u5e94\u7684\u4ea4\u6613\u72b6\u6001", new Object[]{payStatus}));
    }
}

