package com.mini.mshow.model.dto.transfer;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.dbto.able.IsOneSubject;
import com.mini.mshow.model.type.SubjectType;


public class SubjectKeyDto implements IsOneSubject{

	private Integer authorId;
	
	private SubjectType subjectType;
	
	private Integer subjectId;
	
	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}

	public SubjectType getSubjectType() {
		return subjectType;
	}

	public void setSubjectType(SubjectType subjectType) {
		this.subjectType = subjectType;
	}

	public Integer getSubjectId() {
		return subjectId;
	}

	public void setSubjectId(Integer subjectId) {
		this.subjectId = subjectId;
	}

	@Override
	public Integer showAuthorId() {
		return authorId;
	}

	@Override
	public SubjectType showSubectType() {
		return subjectType;
	}

	@Override
	public Integer showSubjectId() {
		return subjectId;
	}
	
	public String showKey(){
		return "" + this.subjectType + "-" + this.subjectId;
	}
	
	public SubjectKeyDto(){}

	public SubjectKeyDto(SubjectType subjectType, Integer subjectId) {
		super();
		AssertUtil.assertMethodRequire(subjectType, "subjectType");
		AssertUtil.assertMethodRequire(subjectId, "subjectId");
		this.subjectType = subjectType;
		this.subjectId = subjectId;
	}
	
}
